/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PageDrawer;

public class PDFRenderer {
    protected final PDDocument document;

    public PDFRenderer(PDDocument document) {
        this.document = document;
    }

    public Bitmap renderImage(int pageIndex) throws IOException {
        return this.renderImage(pageIndex, 1.0f, Bitmap.Config.ARGB_8888);
    }

    public Bitmap renderImage(int pageIndex, float scale, Bitmap.Config config) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        PDRectangle cropbBox = page.getCropBox();
        float widthPt = cropbBox.getWidth();
        float heightPt = cropbBox.getHeight();
        int widthPx = Math.round(widthPt * scale);
        int heightPx = Math.round(heightPt * scale);
        int rotationAngle = page.getRotation();
        Bitmap image = rotationAngle == 90 || rotationAngle == 270 ? Bitmap.createBitmap((int)heightPx, (int)widthPx, (Bitmap.Config)config) : Bitmap.createBitmap((int)widthPx, (int)heightPx, (Bitmap.Config)config);
        Paint paint = new Paint();
        Canvas canvas = new Canvas(image);
        if (config != Bitmap.Config.ARGB_8888) {
            paint.setColor(-1);
            paint.setStyle(Paint.Style.FILL);
            canvas.drawRect(0.0f, 0.0f, (float)image.getWidth(), (float)image.getHeight(), paint);
            paint.reset();
        }
        this.renderPage(page, paint, canvas, image.getWidth(), image.getHeight(), scale, scale);
        return image;
    }

    public void renderPage(PDPage page, Paint paint, Canvas canvas, int width, int height, float scaleX, float scaleY) throws IOException {
        canvas.scale(scaleX, scaleY);
        PDRectangle cropBox = page.getCropBox();
        int rotationAngle = page.getRotation();
        if (rotationAngle != 0) {
            float translateX = 0.0f;
            float translateY = 0.0f;
            switch (rotationAngle) {
                case 90: {
                    translateX = cropBox.getHeight();
                    break;
                }
                case 270: {
                    translateY = cropBox.getWidth();
                    break;
                }
                case 180: {
                    translateX = cropBox.getWidth();
                    translateY = cropBox.getHeight();
                }
            }
            canvas.translate(translateX, translateY);
            canvas.rotate((float)Math.toRadians(rotationAngle));
        }
        PageDrawer drawer = new PageDrawer(page);
        drawer.drawPage(paint, canvas, cropBox);
    }
}

