/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public final class PDRadioButton
extends PDButton {
    public static final int FLAG_NO_TOGGLE_TO_OFF = 16384;

    public PDRadioButton(PDAcroForm theAcroForm) {
        super(theAcroForm);
        this.setRadioButton(true);
    }

    public PDRadioButton(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
    }

    public void setRadiosInUnison(boolean radiosInUnison) {
        this.getDictionary().setFlag(COSName.FF, 0x2000000, radiosInUnison);
    }

    public boolean isRadiosInUnison() {
        return this.getDictionary().getFlag(COSName.FF, 0x2000000);
    }

    public String getExportValue() throws IOException {
        List<String> options = this.getOptions();
        if (options.isEmpty()) {
            return this.getValue();
        }
        String fieldValue = this.getValue();
        List<COSObjectable> kids = this.getKids();
        int idx = 0;
        for (COSObjectable kid : kids) {
            if (!(kid instanceof PDCheckbox)) continue;
            PDCheckbox btn = (PDCheckbox)kid;
            if (btn.getOnValue().equals(fieldValue)) break;
            ++idx;
        }
        if (idx <= options.size()) {
            return options.get(idx);
        }
        return "";
    }

    @Override
    public String getValue() throws IOException {
        COSBase attribute = this.getInheritableAttribute(COSName.V);
        if (attribute == null) {
            return "";
        }
        if (attribute instanceof COSName) {
            return ((COSName)attribute).getName();
        }
        throw new IOException("Expected a COSName entry but got " + attribute.getClass().getName());
    }

    @Override
    public void setValue(String fieldValue) {
        if (fieldValue == null) {
            this.removeInheritableAttribute(COSName.V);
        } else {
            COSName nameForValue = COSName.getPDFName(fieldValue);
            this.setInheritableAttribute(COSName.V, nameForValue);
            List<COSObjectable> kids = this.getKids();
            for (COSObjectable kid : kids) {
                if (!(kid instanceof PDAnnotationWidget)) continue;
                PDAppearanceEntry appearanceEntry = ((PDAnnotationWidget)kid).getAppearance().getNormalAppearance();
                if (((COSDictionary)appearanceEntry.getCOSObject()).containsKey(nameForValue)) {
                    ((COSDictionary)kid.getCOSObject()).setName(COSName.AS, fieldValue);
                    continue;
                }
                ((COSDictionary)kid.getCOSObject()).setName(COSName.AS, "Off");
            }
        }
    }
}

