/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import android.util.Log;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.common.PDTextStream;
import org.apache.pdfbox.pdmodel.interactive.form.AppearanceGeneratorHelper;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;

public final class AppearanceGenerator {
    private AppearanceGenerator() {
    }

    public static void generateFieldAppearances(PDField field) throws IOException {
        if (field instanceof PDVariableText) {
            AppearanceGeneratorHelper apHelper = null;
            Object fieldValue = null;
            apHelper = new AppearanceGeneratorHelper(field.getAcroForm(), (PDVariableText)field);
            fieldValue = field.getValue();
            if (fieldValue instanceof String) {
                apHelper.setAppearanceValue((String)fieldValue);
            } else if (fieldValue instanceof PDTextStream) {
                apHelper.setAppearanceValue(((PDTextStream)fieldValue).getAsString());
            } else if (fieldValue != null) {
                Log.d((String)"PdfBoxAndroid", (String)("Can't generate the appearance for values typed " + fieldValue.getClass().getName() + "."));
            }
        } else {
            Log.d((String)"PdfBoxAndroid", (String)"Unable to generate the field appearance.");
        }
    }
}

