/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDestinationNameTreeNode;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.util.awt.AWTColor;

public final class PDOutlineItem
extends PDOutlineNode {
    private static final int ITALIC_FLAG = 1;
    private static final int BOLD_FLAG = 2;

    public PDOutlineItem() {
    }

    public PDOutlineItem(COSDictionary dic) {
        super(dic);
    }

    public void insertSiblingAfter(PDOutlineItem newSibling) {
        this.requireSingleNode(newSibling);
        PDOutlineNode parent = this.getParent();
        newSibling.setParent(parent);
        PDOutlineItem next = this.getNextSibling();
        this.setNextSibling(newSibling);
        newSibling.setPreviousSibling(this);
        if (next != null) {
            newSibling.setNextSibling(next);
            next.setPreviousSibling(newSibling);
        } else if (parent != null) {
            this.getParent().setLastChild(newSibling);
        }
        this.updateParentOpenCountForAddedChild(newSibling);
    }

    public void insertSiblingBefore(PDOutlineItem newSibling) {
        this.requireSingleNode(newSibling);
        PDOutlineNode parent = this.getParent();
        newSibling.setParent(parent);
        PDOutlineItem previous = this.getPreviousSibling();
        this.setPreviousSibling(newSibling);
        newSibling.setNextSibling(this);
        if (previous != null) {
            previous.setNextSibling(newSibling);
            newSibling.setPreviousSibling(previous);
        } else if (parent != null) {
            this.getParent().setFirstChild(newSibling);
        }
        this.updateParentOpenCountForAddedChild(newSibling);
    }

    public PDOutlineItem getPreviousSibling() {
        return this.getOutlineItem(COSName.PREV);
    }

    void setPreviousSibling(PDOutlineNode outlineNode) {
        this.getCOSDictionary().setItem(COSName.PREV, (COSObjectable)outlineNode);
    }

    public PDOutlineItem getNextSibling() {
        return this.getOutlineItem(COSName.NEXT);
    }

    void setNextSibling(PDOutlineNode outlineNode) {
        this.getCOSDictionary().setItem(COSName.NEXT, (COSObjectable)outlineNode);
    }

    public String getTitle() {
        return this.getCOSDictionary().getString(COSName.TITLE);
    }

    public void setTitle(String title) {
        this.getCOSDictionary().setString(COSName.TITLE, title);
    }

    public PDDestination getDestination() throws IOException {
        return PDDestination.create(this.getCOSDictionary().getDictionaryObject(COSName.DEST));
    }

    public void setDestination(PDDestination dest) {
        this.getCOSDictionary().setItem(COSName.DEST, (COSObjectable)dest);
    }

    public void setDestination(PDPage page) {
        PDPageXYZDestination dest = null;
        if (page != null) {
            dest = new PDPageXYZDestination();
            dest.setPage(page);
        }
        this.setDestination(dest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PDPage findDestinationPage(PDDocument doc) throws IOException {
        PDPageDestination pageDestination;
        PDDestination dest = this.getDestination();
        if (dest == null) {
            PDAction outlineAction = this.getAction();
            if (!(outlineAction instanceof PDActionGoTo)) return null;
            dest = ((PDActionGoTo)outlineAction).getDestination();
        }
        if (dest instanceof PDNamedDestination) {
            PDNamedDestination namedDest = (PDNamedDestination)dest;
            PDDocumentNameDictionary namesDict = doc.getDocumentCatalog().getNames();
            if (namesDict == null) return null;
            PDDestinationNameTreeNode destsTree = namesDict.getDests();
            if (destsTree == null) return null;
            pageDestination = (PDPageDestination)destsTree.getValue(namedDest.getNamedDestination());
        } else if (dest instanceof PDPageDestination) {
            pageDestination = (PDPageDestination)dest;
        } else {
            if (dest != null) throw new IOException("Error: Unknown destination type " + dest);
            return null;
        }
        PDPage page = pageDestination.getPage();
        if (page != null) return page;
        int pageNumber = pageDestination.getPageNumber();
        if (pageNumber == -1) return page;
        return doc.getPage(pageNumber - 1);
    }

    public PDAction getAction() {
        return PDActionFactory.createAction((COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.A));
    }

    public void setAction(PDAction action) {
        this.getCOSDictionary().setItem(COSName.A, (COSObjectable)action);
    }

    public PDStructureElement getStructureElement() {
        PDStructureElement se = null;
        COSDictionary dic = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.SE);
        if (dic != null) {
            se = new PDStructureElement(dic);
        }
        return se;
    }

    public void setStructuredElement(PDStructureElement structureElement) {
        this.getCOSDictionary().setItem(COSName.SE, (COSObjectable)structureElement);
    }

    public PDColor getTextColor() {
        COSArray csValues = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.C);
        if (csValues == null) {
            csValues = new COSArray();
            csValues.growToSize(3, new COSFloat(0.0f));
            this.getCOSDictionary().setItem(COSName.C, (COSBase)csValues);
        }
        return new PDColor(csValues, (PDColorSpace)PDDeviceRGB.INSTANCE);
    }

    public void setTextColor(PDColor textColor) {
        this.getCOSDictionary().setItem(COSName.C, (COSBase)textColor.toCOSArray());
    }

    public void setTextColor(AWTColor textColor) {
        COSArray array = new COSArray();
        array.add(new COSFloat((float)textColor.getRed() / 255.0f));
        array.add(new COSFloat((float)textColor.getGreen() / 255.0f));
        array.add(new COSFloat((float)textColor.getBlue() / 255.0f));
        this.getCOSDictionary().setItem(COSName.C, (COSBase)array);
    }

    public boolean isItalic() {
        return this.getCOSDictionary().getFlag(COSName.F, 1);
    }

    public void setItalic(boolean italic) {
        this.getCOSDictionary().setFlag(COSName.F, 1, italic);
    }

    public boolean isBold() {
        return this.getCOSDictionary().getFlag(COSName.F, 2);
    }

    public void setBold(boolean bold) {
        this.getCOSDictionary().setFlag(COSName.F, 2, bold);
    }
}

