/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;

public class PDAppearanceCharacteristicsDictionary
implements COSObjectable {
    private final COSDictionary dictionary;

    public PDAppearanceCharacteristicsDictionary(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public int getRotation() {
        return this.getDictionary().getInt(COSName.R, 0);
    }

    public void setRotation(int rotation) {
        this.getDictionary().setInt(COSName.R, rotation);
    }

    public PDColor getBorderColour() {
        return this.getColor(COSName.BC);
    }

    public void setBorderColour(PDColor c) {
        this.getDictionary().setItem(COSName.BC, (COSBase)c.toCOSArray());
    }

    public PDColor getBackground() {
        return this.getColor(COSName.BG);
    }

    public void setBackground(PDColor c) {
        this.getDictionary().setItem(COSName.BG, (COSBase)c.toCOSArray());
    }

    public String getNormalCaption() {
        return this.getDictionary().getString("CA");
    }

    public void setNormalCaption(String caption) {
        this.getDictionary().setString("CA", caption);
    }

    public String getRolloverCaption() {
        return this.getDictionary().getString("RC");
    }

    public void setRolloverCaption(String caption) {
        this.getDictionary().setString("RC", caption);
    }

    public String getAlternateCaption() {
        return this.getDictionary().getString("AC");
    }

    public void setAlternateCaption(String caption) {
        this.getDictionary().setString("AC", caption);
    }

    public PDFormXObject getNormalIcon() {
        COSBase i = this.getDictionary().getDictionaryObject("I");
        if (i instanceof COSStream) {
            return new PDFormXObject(new PDStream((COSStream)i), "I");
        }
        return null;
    }

    public PDFormXObject getRolloverIcon() {
        COSBase i = this.getDictionary().getDictionaryObject("RI");
        if (i instanceof COSStream) {
            return new PDFormXObject(new PDStream((COSStream)i), "RI");
        }
        return null;
    }

    public PDFormXObject getAlternateIcon() {
        COSBase i = this.getDictionary().getDictionaryObject("IX");
        if (i instanceof COSStream) {
            return new PDFormXObject(new PDStream((COSStream)i), "IX");
        }
        return null;
    }

    private PDColor getColor(COSName itemName) {
        COSBase c = this.getDictionary().getItem(itemName);
        if (c instanceof COSArray) {
            PDDeviceColorSpace colorSpace = null;
            switch (((COSArray)c).size()) {
                case 1: {
                    colorSpace = PDDeviceGray.INSTANCE;
                    break;
                }
                case 3: {
                    colorSpace = PDDeviceRGB.INSTANCE;
                    break;
                }
            }
            return new PDColor((COSArray)c, (PDColorSpace)colorSpace);
        }
        return null;
    }
}

