/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;

public class PDTilingPattern
extends PDAbstractPattern
implements PDContentStream {
    public static final int PAINT_COLORED = 1;
    public static final int PAINT_UNCOLORED = 2;
    public static final int TILING_CONSTANT_SPACING = 1;
    public static final int TILING_NO_DISTORTION = 2;
    public static final int TILING_CONSTANT_SPACING_FASTER_TILING = 3;

    public PDTilingPattern() {
        this.getCOSDictionary().setInt(COSName.PATTERN_TYPE, 1);
    }

    public PDTilingPattern(COSDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    @Override
    public int getPatternType() {
        return 1;
    }

    @Override
    public void setLength(int length) {
        this.getCOSDictionary().setInt(COSName.LENGTH, length);
    }

    @Override
    public int getLength() {
        return this.getCOSDictionary().getInt(COSName.LENGTH, 0);
    }

    @Override
    public void setPaintType(int paintType) {
        this.getCOSDictionary().setInt(COSName.PAINT_TYPE, paintType);
    }

    public int getPaintType() {
        return this.getCOSDictionary().getInt(COSName.PAINT_TYPE, 0);
    }

    public void setTilingType(int tilingType) {
        this.getCOSDictionary().setInt(COSName.TILING_TYPE, tilingType);
    }

    public int getTilingType() {
        return this.getCOSDictionary().getInt(COSName.TILING_TYPE, 0);
    }

    public void setXStep(float xStep) {
        this.getCOSDictionary().setFloat(COSName.X_STEP, xStep);
    }

    public float getXStep() {
        float xStep = this.getCOSDictionary().getFloat(COSName.X_STEP, 0.0f);
        return xStep == 32767.0f ? 0.0f : xStep;
    }

    public void setYStep(float yStep) {
        this.getCOSDictionary().setFloat(COSName.Y_STEP, yStep);
    }

    public float getYStep() {
        float yStep = this.getCOSDictionary().getFloat(COSName.Y_STEP, 0.0f);
        return yStep == 32767.0f ? 0.0f : yStep;
    }

    @Override
    public COSStream getContentStream() {
        return (COSStream)this.getCOSObject();
    }

    @Override
    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        if (resources != null) {
            this.getCOSDictionary().setItem(COSName.RESOURCES, (COSObjectable)resources);
        } else {
            this.getCOSDictionary().removeItem(COSName.RESOURCES);
        }
    }

    @Override
    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSDictionary().removeItem(COSName.BBOX);
        } else {
            this.getCOSDictionary().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }
}

