/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;

public class PDShadingPattern
extends PDAbstractPattern {
    private PDExtendedGraphicsState extendedGraphicsState;
    private PDShading shading;

    public PDShadingPattern() {
        this.getCOSDictionary().setInt(COSName.PATTERN_TYPE, 2);
    }

    public PDShadingPattern(COSDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    @Override
    public int getPatternType() {
        return 2;
    }

    public PDExtendedGraphicsState getExtendedGraphicsState() {
        COSDictionary dictionary;
        if (this.extendedGraphicsState == null && (dictionary = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.EXT_G_STATE)) != null) {
            this.extendedGraphicsState = new PDExtendedGraphicsState(dictionary);
        }
        return this.extendedGraphicsState;
    }

    public void setExternalGraphicsState(PDExtendedGraphicsState extendedGraphicsState) {
        this.extendedGraphicsState = extendedGraphicsState;
        if (extendedGraphicsState != null) {
            this.getCOSDictionary().setItem(COSName.EXT_G_STATE, (COSObjectable)extendedGraphicsState);
        } else {
            this.getCOSDictionary().removeItem(COSName.EXT_G_STATE);
        }
    }

    public PDShading getShading() throws IOException {
        COSDictionary dictionary;
        if (this.shading == null && (dictionary = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.SHADING)) != null) {
            this.shading = PDShading.create(dictionary);
        }
        return this.shading;
    }

    public void setShading(PDShading shadingResources) {
        this.shading = shadingResources;
        if (shadingResources != null) {
            this.getCOSDictionary().setItem(COSName.SHADING, (COSObjectable)shadingResources);
        } else {
            this.getCOSDictionary().removeItem(COSName.SHADING);
        }
    }
}

