/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.PDMemoryStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;

final class SampledImageReader {
    private SampledImageReader() {
    }

    public static Bitmap getRGBImage(PDImage pdImage, COSArray colorKey) throws IOException {
        Log.e((String)"PdfBoxAndroid", (String)"getting image");
        if (pdImage.getStream() instanceof PDMemoryStream ? pdImage.getStream().getLength() == 0 : pdImage.getStream().getStream().getFilteredLength() == 0L) {
            throw new IOException("Image stream is empty");
        }
        InputStream input = pdImage.getStream().createInputStream();
        return BitmapFactory.decodeStream((InputStream)input);
    }

    private static float[] getDecodeArray(PDImage pdImage) throws IOException {
        COSArray cosDecode = pdImage.getDecode();
        float[] decode = null;
        if (cosDecode != null) {
            int numberOfComponents = 8;
            if (cosDecode.size() != numberOfComponents * 2) {
                if (pdImage.isStencil() && cosDecode.size() >= 2 && cosDecode.get(0) instanceof COSNumber && cosDecode.get(1) instanceof COSNumber) {
                    float decode0 = ((COSNumber)cosDecode.get(0)).floatValue();
                    float decode1 = ((COSNumber)cosDecode.get(1)).floatValue();
                    if (decode0 >= 0.0f && decode0 <= 1.0f && decode1 >= 0.0f && decode1 <= 1.0f) {
                        Log.w((String)"PdfBoxAndroid", (String)("decode array " + cosDecode + " not compatible with color space, using the first two entries"));
                        return new float[]{decode0, decode1};
                    }
                }
                Log.e((String)"PdfBoxAndroid", (String)("decode array " + cosDecode + " not compatible with color space, using default"));
            } else {
                decode = cosDecode.toFloatArray();
            }
        }
        if (decode == null) {
            return new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
        }
        return decode;
    }
}

