/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.ImageFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class JPEGFactory
extends ImageFactory {
    private JPEGFactory() {
    }

    public static PDImageXObject createFromStream(PDDocument document, InputStream stream) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(IOUtils.toByteArray(stream));
        Bitmap awtImage = JPEGFactory.readJPEG(byteStream);
        byteStream.reset();
        PDImageXObject pdImage = new PDImageXObject(document, byteStream, COSName.DCT_DECODE, awtImage.getWidth(), awtImage.getHeight(), 8, PDDeviceRGB.INSTANCE);
        if (awtImage.hasAlpha()) {
            throw new UnsupportedOperationException("alpha channel not implemented");
        }
        return pdImage;
    }

    private static Bitmap readJPEG(InputStream stream) throws IOException {
        return BitmapFactory.decodeStream((InputStream)stream);
    }
}

