/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.CharMetric;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.fontbox.pfb.PfbParser;
import org.apache.fontbox.type1.Type1Font;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.encoding.DictionaryEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.Type1Encoding;

class PDType1FontEmbedder {
    private final Encoding fontEncoding;
    private final FontMetrics metrics;
    private final Type1Font type1;

    public PDType1FontEmbedder(PDDocument doc, COSDictionary dict, InputStream afmStream, InputStream pfbStream) throws IOException {
        dict.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE1);
        AFMParser afmParser = new AFMParser(afmStream);
        this.metrics = afmParser.parse();
        this.fontEncoding = this.encodingFromAFM(this.metrics);
        PDFontDescriptor fd = PDType1FontEmbedder.buildFontDescriptor(this.metrics);
        byte[] pfbBytes = IOUtils.toByteArray(pfbStream);
        PfbParser pfbParser = new PfbParser(new ByteArrayInputStream(pfbBytes));
        this.type1 = Type1Font.createWithPFB(new ByteArrayInputStream(pfbBytes));
        PDStream fontStream = new PDStream(doc, pfbParser.getInputStream(), false);
        fontStream.getStream().setInt("Length", pfbParser.size());
        for (int i = 0; i < pfbParser.getLengths().length; ++i) {
            fontStream.getStream().setInt("Length" + (i + 1), pfbParser.getLengths()[i]);
        }
        fontStream.addCompression();
        fd.setFontFile(fontStream);
        dict.setItem(COSName.FONT_DESC, (COSObjectable)fd);
        dict.setName(COSName.BASE_FONT, this.metrics.getFontName());
        int firstchar = 255;
        int lastchar = 0;
        List<CharMetric> listmetric = this.metrics.getCharMetrics();
        Encoding encoding = this.getFontEncoding();
        int maxWidths = 256;
        ArrayList<Integer> widths = new ArrayList<Integer>(maxWidths);
        int zero = 250;
        Iterator<CharMetric> iter = listmetric.iterator();
        for (int i = 0; i < maxWidths; ++i) {
            widths.add(zero);
        }
        while (iter.hasNext()) {
            CharMetric m = iter.next();
            int n = m.getCharacterCode();
            if (n <= 0) continue;
            firstchar = Math.min(firstchar, n);
            lastchar = Math.max(lastchar, n);
            if (!(m.getWx() > 0.0f)) continue;
            int width = Math.round(m.getWx());
            widths.set(n, width);
        }
        dict.setInt(COSName.FIRST_CHAR, 0);
        dict.setInt(COSName.LAST_CHAR, 255);
        dict.setItem(COSName.WIDTHS, (COSBase)COSArrayList.converterToCOSArray(widths));
    }

    static PDFontDescriptor buildFontDescriptor(FontMetrics metrics) {
        boolean isSymbolic = metrics.getEncodingScheme().equals("FontSpecific");
        PDFontDescriptor fd = new PDFontDescriptor();
        fd.setFontName(metrics.getFontName());
        fd.setFontFamily(metrics.getFamilyName());
        fd.setNonSymbolic(!isSymbolic);
        fd.setSymbolic(isSymbolic);
        fd.setFontBoundingBox(new PDRectangle(metrics.getFontBBox()));
        fd.setItalicAngle(metrics.getItalicAngle());
        fd.setAscent(metrics.getAscender());
        fd.setDescent(metrics.getDescender());
        fd.setCapHeight(metrics.getCapHeight());
        fd.setXHeight(metrics.getXHeight());
        fd.setAverageWidth(metrics.getAverageCharacterWidth());
        fd.setCharacterSet(metrics.getCharacterSet());
        fd.setStemV(0.0f);
        return fd;
    }

    private DictionaryEncoding encodingFromAFM(FontMetrics metrics) throws IOException {
        Type1Encoding encoding = new Type1Encoding(metrics);
        COSArray differences = new COSArray();
        differences.add(COSInteger.ZERO);
        for (int i = 0; i < 256; ++i) {
            differences.add(COSName.getPDFName(encoding.getName(i)));
        }
        differences.set(224, COSName.getPDFName("germandbls"));
        differences.set(229, COSName.getPDFName("adieresis"));
        differences.set(247, COSName.getPDFName("odieresis"));
        differences.set(253, COSName.getPDFName("udieresis"));
        differences.set(197, COSName.getPDFName("Adieresis"));
        differences.set(215, COSName.getPDFName("Odieresis"));
        differences.set(221, COSName.getPDFName("Udieresis"));
        return new DictionaryEncoding(COSName.STANDARD_ENCODING, differences);
    }

    public Encoding getFontEncoding() {
        return this.fontEncoding;
    }

    public FontMetrics getFontMetrics() {
        return this.metrics;
    }

    public Type1Font getType1Font() {
        return this.type1;
    }
}

