/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.font.FontProvider;

final class FileSystemFontProvider
extends FontProvider {
    private final Map<String, File> ttfFontFiles = new HashMap<String, File>();
    private final Map<String, File> cffFontFiles = new HashMap<String, File>();
    private final Map<String, File> type1FontFiles = new HashMap<String, File>();
    private final Map<String, TrueTypeFont> ttfFonts = new HashMap<String, TrueTypeFont>();
    private final Map<String, CFFFont> cffFonts = new HashMap<String, CFFFont>();
    private final Map<String, Type1Font> type1Fonts = new HashMap<String, Type1Font>();

    FileSystemFontProvider() {
        Log.v((String)"PdfBoxAndroid", (String)"Will search the local system for fonts");
        int count = 0;
        FontFileFinder fontFileFinder = new FontFileFinder();
        List<URI> fonts = fontFileFinder.find();
        for (URI font : fonts) {
            ++count;
            File fontFile = new File(font);
            try {
                if (fontFile.getPath().toLowerCase().endsWith(".ttf") || fontFile.getPath().toLowerCase().endsWith(".otf")) {
                    this.addOpenTypeFont(fontFile);
                    continue;
                }
                if (!fontFile.getPath().toLowerCase().endsWith(".pfb")) continue;
                this.addType1Font(fontFile);
            }
            catch (IOException e) {
                Log.e((String)"PdfBoxAndroid", (String)("Error parsing font " + fontFile.getPath()), (Throwable)e);
            }
        }
        Log.v((String)"PdfBoxAndroid", (String)("Found " + count + " fonts on the local system"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpenTypeFont(File otfFile) throws IOException {
        TTFParser ttfParser = new TTFParser(false, true);
        TrueTypeFont ttf = null;
        try {
            ttf = ttfParser.parse(otfFile);
        }
        catch (NullPointerException e) {
            Log.e((String)"PdfBoxAndroid", (String)("Could not load font file: " + otfFile), (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)"PdfBoxAndroid", (String)("Could not load font file: " + otfFile), (Throwable)e);
        }
        try {
            NamingTable nameTable = null;
            if (ttf != null) {
                nameTable = ttf.getNaming();
            }
            if (nameTable == null) {
                Log.w((String)"PdfBoxAndroid", (String)("Missing 'name' table in font " + otfFile));
            } else if (nameTable.getPostScriptName() != null) {
                String format;
                String psName = nameTable.getPostScriptName();
                if (ttf.getTableMap().get("CFF ") != null) {
                    format = "OTF";
                    this.cffFontFiles.putAll(this.toMap(this.getNames(ttf), otfFile));
                } else {
                    format = "TTF";
                    this.ttfFontFiles.putAll(this.toMap(this.getNames(ttf), otfFile));
                }
                Log.v((String)"PdfBoxAndroid", (String)(format + ": '" + psName + "' / '" + nameTable.getFontFamily() + "' / '" + nameTable.getFontSubFamily() + "'"));
            } else {
                Log.w((String)"PdfBoxAndroid", (String)("Missing 'name' entry for PostScript name in font " + otfFile));
            }
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType1Font(File pfbFile) throws IOException {
        try (FileInputStream input = new FileInputStream(pfbFile);){
            Type1Font type1 = Type1Font.createWithPFB(input);
            String psName = type1.getFontName();
            this.type1FontFiles.putAll(this.toMap(this.getNames(type1), pfbFile));
            Log.v((String)"PdfBoxAndroid", (String)("PFB: '" + psName + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'"));
        }
    }

    @Override
    public synchronized TrueTypeFont getTrueTypeFont(String postScriptName) {
        TrueTypeFont ttf = this.ttfFonts.get(postScriptName);
        if (ttf != null) {
            return ttf;
        }
        File file = this.ttfFontFiles.get(postScriptName);
        if (file != null) {
            TTFParser ttfParser = new TTFParser(false, true);
            try {
                ttf = ttfParser.parse(file);
                for (String name : this.getNames(ttf)) {
                    this.ttfFonts.put(name, ttf);
                }
                Log.d((String)"PdfBoxAndroid", (String)("Loaded " + postScriptName + " from " + file));
                return ttf;
            }
            catch (NullPointerException e) {
                Log.e((String)"PdfBoxAndroid", (String)("Could not load font file: " + file), (Throwable)e);
            }
            catch (IOException e) {
                Log.e((String)"PdfBoxAndroid", (String)("Could not load font file: " + file), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CFFFont getCFFFont(String postScriptName) {
        CFFFont cff = this.cffFonts.get(postScriptName);
        if (cff != null) {
            return cff;
        }
        File file = this.cffFontFiles.get(postScriptName);
        if (file != null) {
            CFFFont cFFFont;
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                byte[] bytes = IOUtils.toByteArray(input);
                CFFParser cffParser = new CFFParser();
                cff = cffParser.parse(bytes).get(0);
                for (String name : this.getNames(cff)) {
                    this.cffFonts.put(name, cff);
                }
                Log.d((String)"PdfBoxAndroid", (String)("Loaded " + postScriptName + " from " + file));
                cFFFont = cff;
            }
            catch (IOException e) {
                try {
                    Log.e((String)"PdfBoxAndroid", (String)("Could not load font file: " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly(input);
            }
            IOUtils.closeQuietly(input);
            return cFFFont;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Type1Font getType1Font(String postScriptName) {
        Type1Font type1 = this.type1Fonts.get(postScriptName);
        if (type1 != null) {
            return type1;
        }
        File file = this.type1FontFiles.get(postScriptName);
        if (file != null) {
            Type1Font type1Font;
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                type1 = Type1Font.createWithPFB(input);
                for (String name : this.getNames(type1)) {
                    this.type1Fonts.put(name, type1);
                }
                Log.d((String)"PdfBoxAndroid", (String)("Loaded " + postScriptName + " from " + file));
                type1Font = type1;
            }
            catch (IOException e) {
                try {
                    Log.e((String)"PdfBoxAndroid", (String)("Could not load font file: " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly(input);
            }
            IOUtils.closeQuietly(input);
            return type1Font;
        }
        return null;
    }

    private Map<String, File> toMap(Set<String> names, File file) {
        HashMap<String, File> map = new HashMap<String, File>();
        for (String name : names) {
            map.put(name, file);
        }
        return map;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, File> entry : this.ttfFontFiles.entrySet()) {
            sb.append("TTF: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        for (Map.Entry<String, File> entry : this.cffFontFiles.entrySet()) {
            sb.append("OTF: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        for (Map.Entry<String, File> entry : this.type1FontFiles.entrySet()) {
            sb.append("PFB: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        return sb.toString();
    }
}

