/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;

final class CMapManager {
    protected static Map<String, CMap> cMapCache = Collections.synchronizedMap(new HashMap());

    private CMapManager() {
    }

    public static CMap getPredefinedCMap(String cMapName) throws IOException {
        CMap cmap = cMapCache.get(cMapName);
        if (cmap != null) {
            return cmap;
        }
        CMapParser parser = new CMapParser();
        CMap targetCmap = parser.parsePredefined(cMapName);
        cMapCache.put(targetCmap.getName(), targetCmap);
        return targetCmap;
    }

    public static CMap parseCMap(InputStream cMapStream) throws IOException {
        CMap targetCmap = null;
        if (cMapStream != null) {
            CMapParser parser = new CMapParser();
            targetCmap = parser.parse(cMapStream);
        }
        return targetCmap;
    }
}

