/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.io.RandomAccessFileInputStream;
import org.apache.pdfbox.io.RandomAccessFileOutputStream;

public class COSStream
extends COSDictionary
implements Closeable {
    private static final int BUFFER_SIZE = 16384;
    private final RandomAccess buffer;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;
    private DecodeResult decodeResult;
    private File scratchFile;

    public COSStream() {
        this(false, null);
    }

    public COSStream(COSDictionary dictionary) {
        this(dictionary, false, null);
    }

    public COSStream(boolean useScratchFiles, File scratchDirectory) {
        this.buffer = useScratchFiles ? this.createScratchFile(scratchDirectory) : new RandomAccessBuffer();
    }

    public COSStream(COSDictionary dictionary, boolean useScratchFiles, File scratchDirectory) {
        super(dictionary);
        this.buffer = useScratchFiles ? this.createScratchFile(scratchDirectory) : new RandomAccessBuffer();
    }

    private RandomAccess createScratchFile(File scratchDirectory) {
        try {
            this.scratchFile = File.createTempFile("PDFBox", null, scratchDirectory);
            return new RandomAccessFile(this.scratchFile, "rw");
        }
        catch (IOException exception) {
            Log.e((String)"PdfBoxAndroid", (String)"Can't create temp file, using memory buffer instead", (Throwable)exception);
            return new RandomAccessBuffer();
        }
    }

    public InputStream getFilteredStream() throws IOException {
        if (this.buffer.isClosed()) {
            throw new IOException("COSStream has been closed and cannot be read. Perhaps its enclosing PDDocument has been closed?");
        }
        if (this.filteredStream == null) {
            this.doEncode();
        }
        long position = this.filteredStream.getPosition();
        long length = this.filteredStream.getLengthWritten();
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.buffer, position, length);
        return new BufferedInputStream(input, 16384);
    }

    public long getFilteredLength() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        return this.filteredStream.getLength();
    }

    public InputStream getUnfilteredStream() throws IOException {
        InputStream retval;
        if (this.buffer.isClosed()) {
            throw new IOException("COSStream has been closed and cannot be read. Perhaps its enclosing PDDocument has been closed?");
        }
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLengthWritten();
            RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.buffer, position, length);
            retval = new BufferedInputStream(input, 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public DecodeResult getDecodeResult() throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream == null || this.decodeResult == null) {
            StringBuilder filterInfo = new StringBuilder();
            COSBase filters = this.getFilters();
            if (filters != null) {
                filterInfo.append(" - filter: ");
                if (filters instanceof COSName) {
                    filterInfo.append(((COSName)filters).getName());
                } else if (filters instanceof COSArray) {
                    COSArray filterArray = (COSArray)filters;
                    for (int i = 0; i < filterArray.size(); ++i) {
                        if (filterArray.size() > 1) {
                            filterInfo.append(", ");
                        }
                        filterInfo.append(((COSName)filterArray.get(i)).getName());
                    }
                }
            }
            String subtype = this.getNameAsString(COSName.SUBTYPE);
            throw new IOException(subtype + " stream was not read" + filterInfo);
        }
        return this.decodeResult;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return visitor.visitFromStream(this);
    }

    private void doDecode() throws IOException {
        this.unFilteredStream = this.filteredStream;
        COSBase filters = this.getFilters();
        if (filters == null) {
            this.decodeResult = DecodeResult.DEFAULT;
        } else if (filters instanceof COSName) {
            this.doDecode((COSName)filters, 0);
        } else if (filters instanceof COSArray) {
            COSArray filterArray = (COSArray)filters;
            for (int i = 0; i < filterArray.size(); ++i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doDecode(filterName, i);
            }
        } else {
            throw new IOException("Error: Unknown filter type:" + filters);
        }
    }

    private void doDecode(COSName filterName, int filterIndex) throws IOException {
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        boolean done = false;
        IOException exception = null;
        long position = this.unFilteredStream.getPosition();
        long length = this.unFilteredStream.getLength();
        long writtenLength = this.unFilteredStream.getLengthWritten();
        if (length == 0L && writtenLength == 0L) {
            IOUtils.closeQuietly(this.unFilteredStream);
            this.unFilteredStream = new RandomAccessFileOutputStream(this.buffer);
            done = true;
        } else {
            int tryCount;
            for (tryCount = 0; length > 0L && !done && tryCount < 5; ++tryCount) {
                try {
                    this.attemptDecode(position, length, filter, filterIndex);
                    done = true;
                    continue;
                }
                catch (IOException io) {
                    --length;
                    exception = io;
                }
            }
            if (!done) {
                length = writtenLength;
                for (tryCount = 0; !done && tryCount < 5; ++tryCount) {
                    try {
                        this.attemptDecode(position, length, filter, filterIndex);
                        done = true;
                        continue;
                    }
                    catch (IOException io) {
                        --length;
                        exception = io;
                    }
                }
            }
        }
        if (!done && exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDecode(long position, long length, Filter filter, int filterIndex) throws IOException {
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new RandomAccessFileInputStream(this.buffer, position, length), 16384);
            IOUtils.closeQuietly(this.unFilteredStream);
            this.unFilteredStream = new RandomAccessFileOutputStream(this.buffer);
            this.decodeResult = filter.decode(input, this.unFilteredStream, this, filterIndex);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
    }

    private void doEncode() throws IOException {
        this.filteredStream = this.unFilteredStream;
        COSBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof COSName) {
                this.doEncode((COSName)filters, 0);
            } else if (filters instanceof COSArray) {
                COSArray filterArray = (COSArray)filters;
                for (int i = filterArray.size() - 1; i >= 0; --i) {
                    COSName filterName = (COSName)filterArray.get(i);
                    this.doEncode(filterName, i);
                }
            }
        }
    }

    private void doEncode(COSName filterName, int filterIndex) throws IOException {
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.buffer, this.filteredStream.getPosition(), this.filteredStream.getLength()), 16384);
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.buffer);
        filter.encode(input, this.filteredStream, this, filterIndex);
        IOUtils.closeQuietly(input);
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    public OutputStream createFilteredStream() throws IOException {
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = null;
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.buffer);
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        OutputStream out = this.createFilteredStream();
        this.filteredStream.setExpectedLength(expectedLength);
        return out;
    }

    public void setFilters(COSBase filters) throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        this.setItem(COSName.FILTER, filters);
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = new RandomAccessFileOutputStream(this.buffer);
        return new BufferedOutputStream(this.unFilteredStream, 16384);
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            this.buffer.close();
        }
        if (this.filteredStream != null) {
            this.filteredStream.close();
        }
        if (this.unFilteredStream != null) {
            this.unFilteredStream.close();
        }
        if (this.scratchFile != null && this.scratchFile.exists() && !this.scratchFile.delete()) {
            throw new IOException("Can't delete the temporary scratch file " + this.scratchFile.getAbsolutePath());
        }
    }
}

