/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import android.graphics.Path;
import java.io.IOException;
import org.apache.fontbox.ttf.GlyfCompositeDescript;
import org.apache.fontbox.ttf.GlyfDescript;
import org.apache.fontbox.ttf.GlyfSimpleDescript;
import org.apache.fontbox.ttf.GlyphDescription;
import org.apache.fontbox.ttf.GlyphRenderer;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.util.BoundingBox;

public class GlyphData {
    private short xMin;
    private short yMin;
    private short xMax;
    private short yMax;
    private BoundingBox boundingBox = null;
    private short numberOfContours;
    private GlyfDescript glyphDescription = null;

    public void initData(GlyphTable glyphTable, TTFDataStream data) throws IOException {
        this.numberOfContours = data.readSignedShort();
        this.xMin = data.readSignedShort();
        this.yMin = data.readSignedShort();
        this.xMax = data.readSignedShort();
        this.yMax = data.readSignedShort();
        this.boundingBox = new BoundingBox(this.xMin, this.yMin, this.xMax, this.yMax);
        this.glyphDescription = this.numberOfContours >= 0 ? new GlyfSimpleDescript(this.numberOfContours, data) : new GlyfCompositeDescript(data, glyphTable);
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBoxValue) {
        this.boundingBox = boundingBoxValue;
    }

    public short getNumberOfContours() {
        return this.numberOfContours;
    }

    public void setNumberOfContours(short numberOfContoursValue) {
        this.numberOfContours = numberOfContoursValue;
    }

    public GlyphDescription getDescription() {
        return this.glyphDescription;
    }

    public Path getPath() {
        return new GlyphRenderer(this.glyphDescription).getPath();
    }

    public short getXMaximum() {
        return this.xMax;
    }

    public short getXMinimum() {
        return this.xMin;
    }

    public short getYMaximum() {
        return this.yMax;
    }

    public short getYMinimum() {
        return this.yMin;
    }
}

