package org.apache.pdfbox.contentstream.operator.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSNumber;

/**
 * TD: Move text position and set leading.
 *
 * @author Laurent Huault
 */
public class MoveTextSetLeading extends OperatorProcessor
{
    @Override
    public void process(Operator operator, List<COSBase> arguments) throws IOException
    {
        //move text position and set leading
        COSNumber y = (COSNumber)arguments.get(1);

        ArrayList<COSBase> args = new ArrayList<COSBase>();
        args.add(new COSFloat(-1 * y.floatValue()));
        context.processOperator("TL", args);
        context.processOperator("Td", arguments);
    }

    @Override
    public String getName()
    {
        return "TD";
    }
}
