/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.DeploymentValidationService;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.SerializableBeanVault;
import org.apache.webbeans.context.creational.CreationalContextFactory;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.conversation.DefaultConversationService;
import org.apache.webbeans.corespi.se.DefaultApplicationBoundaryService;
import org.apache.webbeans.corespi.se.DefaultContextsService;
import org.apache.webbeans.corespi.se.DefaultJndiService;
import org.apache.webbeans.corespi.security.SimpleSecurityService;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.proxy.SubclassProxyFactory;
import org.apache.webbeans.service.DefaultInjectionPointService;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.ApplicationBoundaryService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ConversationService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.DefaultBeanArchiveService;

public class WebBeansContext {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansContext.class);
    private final Map<Class<?>, Object> managerMap = new HashMap();
    private final Map<Class<?>, Object> serviceMap = new HashMap();
    private final WebBeansUtil webBeansUtil = new WebBeansUtil(this);
    private final AlternativesManager alternativesManager = new AlternativesManager(this);
    private final AnnotatedElementFactory annotatedElementFactory = new AnnotatedElementFactory(this);
    private final BeanManagerImpl beanManagerImpl = new BeanManagerImpl(this);
    private final CreationalContextFactory creationalContextFactory = new CreationalContextFactory(this);
    private final DecoratorsManager decoratorsManager = new DecoratorsManager(this);
    private final ExtensionLoader extensionLoader = new ExtensionLoader(this);
    private final InterceptorsManager interceptorsManager = new InterceptorsManager(this);
    private final InterceptorDecoratorProxyFactory interceptorDecoratorProxyFactory;
    private final NormalScopeProxyFactory normalScopeProxyFactory;
    private final SubclassProxyFactory subclassProxyFactory;
    private final OpenWebBeansConfiguration openWebBeansConfiguration;
    private final PluginLoader pluginLoader = new PluginLoader();
    private final SerializableBeanVault serializableBeanVault = new SerializableBeanVault();
    private final StereoTypeManager stereoTypeManager = new StereoTypeManager();
    private final AnnotationManager annotationManager;
    private final InjectionPointFactory injectionPointFactory;
    private final InterceptorUtil interceptorUtil = new InterceptorUtil(this);
    private final SecurityService securityService;
    private final LoaderService loaderService;
    private BeanArchiveService beanArchiveService;
    private final InterceptorResolutionService interceptorResolutionService = new InterceptorResolutionService(this);
    private final DeploymentValidationService deploymentValidationService = new DeploymentValidationService(this);
    private ScannerService scannerService;
    private ContextsService contextsService;
    private final ConversationManager conversationManager;
    private ConversationService conversationService;
    private final ApplicationBoundaryService applicationBoundaryService;
    private final NotificationManager notificationManager;

    public WebBeansContext() {
        this(null, new OpenWebBeansConfiguration());
    }

    public WebBeansContext(Map<Class<?>, Object> initialServices, Properties properties) {
        this(initialServices, new OpenWebBeansConfiguration(properties));
    }

    private WebBeansContext(Map<Class<?>, Object> initialServices, OpenWebBeansConfiguration openWebBeansConfiguration) {
        this.openWebBeansConfiguration = openWebBeansConfiguration != null ? openWebBeansConfiguration : new OpenWebBeansConfiguration();
        this.annotationManager = new AnnotationManager(this);
        if (initialServices == null || !initialServices.containsKey(LoaderService.class)) {
            String implementationLoaderServiceName = this.openWebBeansConfiguration.getProperty(LoaderService.class.getName());
            if (implementationLoaderServiceName == null) {
                this.serviceMap.put(LoaderService.class, new DefaultLoaderService());
            } else {
                this.serviceMap.put(LoaderService.class, LoaderService.class.cast(this.get(implementationLoaderServiceName)));
            }
        }
        if (initialServices != null) {
            for (Map.Entry<Class<?>, Object> entry : initialServices.entrySet()) {
                if (!entry.getKey().isAssignableFrom(entry.getValue().getClass())) {
                    throw new IllegalArgumentException("Initial service claiming to be of type " + entry.getKey() + " is a " + entry.getValue().getClass());
                }
                this.serviceMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.injectionPointFactory = new InjectionPointFactory(this);
        this.loaderService = this.getService(LoaderService.class);
        this.securityService = this.getService(SecurityService.class);
        this.applicationBoundaryService = this.getService(ApplicationBoundaryService.class);
        this.interceptorDecoratorProxyFactory = new InterceptorDecoratorProxyFactory(this);
        this.normalScopeProxyFactory = new NormalScopeProxyFactory(this);
        this.subclassProxyFactory = new SubclassProxyFactory(this);
        this.beanArchiveService = this.getService(BeanArchiveService.class);
        this.conversationManager = new ConversationManager(this);
        this.notificationManager = new NotificationManager(this);
        this.beanManagerImpl.getInjectionResolver().setFastMatching(!"false".equalsIgnoreCase(this.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.container.InjectionResolver.fastMatching")));
    }

    public static WebBeansContext getInstance() {
        WebBeansContext webBeansContext = WebBeansFinder.getSingletonInstance();
        return webBeansContext;
    }

    public static WebBeansContext currentInstance() {
        return WebBeansContext.getInstance();
    }

    public <T> T getService(Class<T> clazz) {
        T t = clazz.cast(this.serviceMap.get(clazz));
        if (t == null) {
            t = this.doServiceLoader(clazz);
            this.registerService(clazz, t);
        }
        return t;
    }

    public <T> void registerService(Class<T> clazz, T t) {
        if (t != null) {
            this.serviceMap.put(clazz, t);
        }
    }

    private <T> T doServiceLoader(Class<T> serviceInterface) {
        String implName = this.getOpenWebBeansConfiguration().getProperty(serviceInterface.getName());
        if (implName == null) {
            List<OpenWebBeansPlugin> plugins = this.getPluginLoader().getPlugins();
            if (plugins != null && plugins.size() > 0) {
                for (OpenWebBeansPlugin plugin : plugins) {
                    if (!plugin.supportService(serviceInterface)) continue;
                    return (T)plugin.getSupportedService(serviceInterface);
                }
            }
            return null;
        }
        return serviceInterface.cast(this.get(implName));
    }

    public InterceptorUtil getInterceptorUtil() {
        return this.interceptorUtil;
    }

    public InjectionPointFactory getInjectionPointFactory() {
        return this.injectionPointFactory;
    }

    public WebBeansUtil getWebBeansUtil() {
        return this.webBeansUtil;
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public OpenWebBeansConfiguration getOpenWebBeansConfiguration() {
        return this.openWebBeansConfiguration;
    }

    public AnnotatedElementFactory getAnnotatedElementFactory() {
        return this.annotatedElementFactory;
    }

    public BeanManagerImpl getBeanManagerImpl() {
        return this.beanManagerImpl;
    }

    public SerializableBeanVault getSerializableBeanVault() {
        return this.serializableBeanVault;
    }

    public CreationalContextFactory getCreationalContextFactory() {
        return this.creationalContextFactory;
    }

    public DecoratorsManager getDecoratorsManager() {
        return this.decoratorsManager;
    }

    public StereoTypeManager getStereoTypeManager() {
        return this.stereoTypeManager;
    }

    public AlternativesManager getAlternativesManager() {
        return this.alternativesManager;
    }

    public InterceptorsManager getInterceptorsManager() {
        return this.interceptorsManager;
    }

    public InterceptorResolutionService getInterceptorResolutionService() {
        return this.interceptorResolutionService;
    }

    public PluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public ExtensionLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public InterceptorDecoratorProxyFactory getInterceptorDecoratorProxyFactory() {
        return this.interceptorDecoratorProxyFactory;
    }

    public NormalScopeProxyFactory getNormalScopeProxyFactory() {
        return this.normalScopeProxyFactory;
    }

    public SubclassProxyFactory getSubclassProxyFactory() {
        return this.subclassProxyFactory;
    }

    public ScannerService getScannerService() {
        if (this.scannerService == null) {
            this.scannerService = this.getService(ScannerService.class);
        }
        return this.scannerService;
    }

    public ContextsService getContextsService() {
        if (this.contextsService == null) {
            this.contextsService = this.getService(ContextsService.class);
        }
        return this.contextsService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public BeanArchiveService getBeanArchiveService() {
        return this.beanArchiveService;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public ConversationService getConversationService() {
        if (this.conversationService == null) {
            this.conversationService = this.getService(ConversationService.class);
        }
        return this.conversationService;
    }

    private Object get(String singletonName) {
        if (DefaultInjectionPointService.class.getName().equals(singletonName)) {
            return new DefaultInjectionPointService(this);
        }
        if (SimpleSecurityService.class.getName().equals(singletonName)) {
            return new SimpleSecurityService();
        }
        if (DefaultApplicationBoundaryService.class.getName().equals(singletonName)) {
            return new DefaultApplicationBoundaryService();
        }
        if (DefaultBeanArchiveService.class.getName().equals(singletonName)) {
            return new DefaultBeanArchiveService();
        }
        if (DefaultJndiService.class.getName().equals(singletonName)) {
            return new DefaultJndiService();
        }
        if (DefaultContextsService.class.getName().equals(singletonName)) {
            return new DefaultContextsService(this);
        }
        if (DefaultConversationService.class.getName().equals(singletonName)) {
            return new DefaultConversationService();
        }
        Class<?> clazz = ClassUtil.getClassFromName(singletonName);
        if (clazz == null) {
            throw new WebBeansException("Class not found exception in creating instance with class : " + singletonName, new ClassNotFoundException("Class with name: " + singletonName + " is not found in the system"));
        }
        return this.get(clazz);
    }

    public <T> T get(Class<T> clazz) {
        T object = clazz.cast(this.managerMap.get(clazz));
        if (object == null) {
            object = this.backwardCompatibilityLookup(clazz);
            if (object == null) {
                object = this.createInstance(clazz);
            }
            this.managerMap.put(clazz, object);
        }
        return object;
    }

    private <T> T backwardCompatibilityLookup(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz == AlternativesManager.class) {
            return clazz.cast(this.alternativesManager);
        }
        if (clazz == AnnotatedElementFactory.class) {
            return clazz.cast(this.annotatedElementFactory);
        }
        if (clazz == BeanManagerImpl.class) {
            return clazz.cast(this.beanManagerImpl);
        }
        if (clazz == ConversationManager.class) {
            return clazz.cast(this.conversationManager);
        }
        if (clazz == CreationalContextFactory.class) {
            return clazz.cast(this.creationalContextFactory);
        }
        if (clazz == DecoratorsManager.class) {
            return clazz.cast(this.decoratorsManager);
        }
        if (clazz == ExtensionLoader.class) {
            return clazz.cast(this.extensionLoader);
        }
        if (clazz == InterceptorsManager.class) {
            return clazz.cast(this.interceptorsManager);
        }
        if (clazz == InterceptorDecoratorProxyFactory.class) {
            return clazz.cast(this.interceptorDecoratorProxyFactory);
        }
        if (clazz == NormalScopeProxyFactory.class) {
            return clazz.cast(this.normalScopeProxyFactory);
        }
        if (clazz == SubclassProxyFactory.class) {
            return clazz.cast(this.subclassProxyFactory);
        }
        if (clazz == OpenWebBeansConfiguration.class) {
            return clazz.cast(this.openWebBeansConfiguration);
        }
        if (clazz == PluginLoader.class) {
            return clazz.cast(this.pluginLoader);
        }
        if (clazz == SerializableBeanVault.class) {
            return clazz.cast(this.serializableBeanVault);
        }
        if (clazz == StereoTypeManager.class) {
            return clazz.cast(this.stereoTypeManager);
        }
        if (clazz == InterceptorResolutionService.class) {
            return clazz.cast(this.interceptorResolutionService);
        }
        if (clazz == NotificationManager.class) {
            return clazz.cast(this.notificationManager);
        }
        return null;
    }

    private <T> T createInstance(Class<T> clazz) {
        if (DefaultLoaderService.class == clazz) {
            return clazz.cast(new DefaultLoaderService());
        }
        if (SimpleSecurityService.class == clazz) {
            return clazz.cast(new SimpleSecurityService());
        }
        if (DefaultApplicationBoundaryService.class == clazz) {
            return clazz.cast(new DefaultApplicationBoundaryService());
        }
        if (DefaultBeanArchiveService.class == clazz) {
            return clazz.cast(new DefaultBeanArchiveService());
        }
        if (DefaultJndiService.class == clazz) {
            return clazz.cast(new DefaultJndiService());
        }
        if (DefaultContextsService.class == clazz) {
            return clazz.cast(new DefaultContextsService(this));
        }
        if (DefaultConversationService.class == clazz) {
            return clazz.cast(new DefaultConversationService());
        }
        try {
            try {
                Constructor<T> constructor = clazz.getConstructor(WebBeansContext.class);
                return constructor.newInstance(this);
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor<T> constructor2 = clazz.getConstructor(new Class[0]);
                    return constructor2.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new WebBeansException("No suitable constructor : " + clazz.getName(), e.getCause());
                }
            }
        }
        catch (InstantiationException e) {
            throw new WebBeansException("Unable to instantiate class : " + clazz.getName(), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new WebBeansException("Unable to instantiate class : " + clazz.getName(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new WebBeansException("Illegal access exception in creating instance with class : " + clazz.getName(), e);
        }
    }

    public void clear() {
        this.destroyServices(this.managerMap.values());
        this.destroyServices(this.serviceMap.values());
        this.managerMap.clear();
        this.serviceMap.clear();
    }

    private void destroyServices(Collection<Object> services) {
        for (Object spiService : services) {
            if (spiService instanceof Closeable) {
                try {
                    ((Closeable)spiService).close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Error while destroying SPI service " + spiService.getClass().getName(), e);
                }
                continue;
            }
            if (!ExecutorService.class.isInstance(spiService)) continue;
            ExecutorService es = (ExecutorService)ExecutorService.class.cast(spiService);
            es.shutdownNow().forEach(r -> {
                try {
                    r.run();
                }
                catch (RuntimeException re) {
                    logger.warning(re.getMessage());
                }
            });
        }
    }

    public LoaderService getLoaderService() {
        return this.loaderService;
    }

    public DeploymentValidationService getDeploymentValidationService() {
        return this.deploymentValidationService;
    }

    public ApplicationBoundaryService getApplicationBoundaryService() {
        return this.applicationBoundaryService;
    }

    public boolean findMissingAnnotatedType(Class<?> missing) {
        return false;
    }
}

