/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.Producer;
import javax.interceptor.Interceptor;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.BuiltInOwbBean;
import org.apache.webbeans.component.CdiInterceptorBean;
import org.apache.webbeans.component.DecoratorBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.CdiInterceptorBeanBuilder;
import org.apache.webbeans.component.creation.DecoratorBeanBuilder;
import org.apache.webbeans.component.creation.ManagedBeanBuilder;
import org.apache.webbeans.component.creation.ObserverMethodsBuilder;
import org.apache.webbeans.component.creation.ProducerFieldBeansBuilder;
import org.apache.webbeans.component.creation.ProducerMethodBeansBuilder;
import org.apache.webbeans.config.EJBWebBeansConfigurator;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.container.AnnotatedTypeWrapper;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectableBeanManager;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.corespi.se.DefaultJndiService;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.event.OwbObserverMethod;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.AnnotatedTypeImpl;
import org.apache.webbeans.portable.BaseProducerProducer;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.portable.events.ProcessBeanAttributesImpl;
import org.apache.webbeans.portable.events.discovery.AfterBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.discovery.AfterDeploymentValidationImpl;
import org.apache.webbeans.portable.events.discovery.AfterTypeDiscoveryImpl;
import org.apache.webbeans.portable.events.discovery.AnnotatedTypeConfiguratorHolder;
import org.apache.webbeans.portable.events.discovery.BeforeBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessBean;
import org.apache.webbeans.portable.events.generics.GProcessManagedBean;
import org.apache.webbeans.portable.events.generics.GProcessSyntheticAnnotatedType;
import org.apache.webbeans.spi.BdaScannerService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.InjectionExceptionUtil;
import org.apache.webbeans.util.SpecializationUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.DefaultBeanArchiveInformation;

public class BeansDeployer {
    private static final Logger logger;
    public static final String JAVAX_ENTERPRISE_PACKAGE = "javax.enterprise.";
    private static final Method GET_PACKAGE;
    protected boolean deployed;
    protected BeanArchiveService beanArchiveService;
    protected boolean discoverEjb;
    private final WebBeansContext webBeansContext;
    private final ScannerService scannerService;
    private final DecoratorsManager decoratorsManager;
    private final InterceptorsManager interceptorsManager;
    private final Map<String, Boolean> packageVetoCache = new HashMap<String, Boolean>();
    private final DefaultBeanArchiveInformation defaultBeanArchiveInformation;

    public BeansDeployer(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanArchiveService = webBeansContext.getBeanArchiveService();
        this.scannerService = webBeansContext.getScannerService();
        this.decoratorsManager = webBeansContext.getDecoratorsManager();
        this.interceptorsManager = webBeansContext.getInterceptorsManager();
        String usage = this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService");
        this.discoverEjb = Boolean.parseBoolean(usage);
        this.defaultBeanArchiveInformation = new DefaultBeanArchiveInformation("default");
        this.defaultBeanArchiveInformation.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ALL);
    }

    public synchronized void deploy(ScannerService scanner) {
        try {
            if (!this.deployed) {
                this.webBeansContext.getExtensionLoader().loadExtensionServices();
                JNDIService service = this.webBeansContext.getService(JNDIService.class);
                if (service instanceof DefaultJndiService) {
                    service.bind("java:comp/BeanManager", (Object)new InjectableBeanManager(this.webBeansContext.getBeanManagerImpl()));
                } else {
                    service.bind("java:comp/BeanManager", (Object)this.webBeansContext.getBeanManagerImpl().getReference());
                }
                this.webBeansContext.getBeanManagerImpl().addInternalBean(this.webBeansContext.getWebBeansUtil().getManagerBean());
                this.webBeansContext.getBeanManagerImpl().addInternalBean(this.webBeansContext.getWebBeansUtil().getRequestContextControllerBean());
                this.fireBeforeBeanDiscoveryEvent();
                this.configureDefaultBeans();
                Map<BeanArchiveService.BeanArchiveInformation, List<AnnotatedType<?>>> annotatedTypesPerBda = this.annotatedTypesFromClassPath(scanner);
                List<AnnotatedType<?>> globalBdaAnnotatedTypes = annotatedTypesPerBda.get(this.defaultBeanArchiveInformation);
                Collection<AnnotatedType<?>> additionalAnnotatedTypes = this.webBeansContext.getBeanManagerImpl().getAdditionalAnnotatedTypes();
                this.addAdditionalAnnotatedTypes(additionalAnnotatedTypes, globalBdaAnnotatedTypes);
                for (List<AnnotatedType<?>> at : annotatedTypesPerBda.values()) {
                    this.registerAlternativesDecoratorsAndInterceptorsWithPriority(at);
                }
                this.deployFromXML(scanner);
                this.addAdditionalAnnotatedTypes(this.fireAfterTypeDiscoveryEvent(), globalBdaAnnotatedTypes);
                final Map<BeanArchiveService.BeanArchiveInformation, Map<AnnotatedType<?>, ExtendedBeanAttributes<?>>> beanAttributesPerBda = this.getBeanAttributes(annotatedTypesPerBda);
                annotatedTypesPerBda.clear();
                SpecializationUtil specializationUtil = new SpecializationUtil(this.webBeansContext);
                specializationUtil.removeDisabledBeanAttributes(beanAttributesPerBda, null, true);
                this.checkStereoTypes(beanAttributesPerBda);
                specializationUtil.removeDisabledBeanAttributes(beanAttributesPerBda, new SpecializationUtil.BeanAttributesProvider(){

                    public <T> BeanAttributes get(AnnotatedType<T> at) {
                        Map beanAttributes;
                        ExtendedBeanAttributes data = null;
                        Iterator iterator = beanAttributesPerBda.values().iterator();
                        while (iterator.hasNext() && (data = (ExtendedBeanAttributes)(beanAttributes = (Map)iterator.next()).get(at)) == null) {
                        }
                        return data == null ? null : data.beanAttributes;
                    }
                }, false);
                this.deployFromBeanAttributes(beanAttributesPerBda);
                this.configureProducerMethodSpecializations();
                this.removeDisabledBeans();
                this.fireAfterBeanDiscoveryEvent();
                this.webBeansContext.getBeanManagerImpl().getInjectionResolver().setStartup(false);
                this.validateAlternatives(beanAttributesPerBda);
                this.validateInjectionPoints();
                this.validateDisposeParameters();
                this.validateDecoratorDecoratedTypes();
                this.validateDecoratorGenericTypes();
                this.validateNames();
                if (this.webBeansContext.getNotificationManager().getObserverMethods().stream().anyMatch(ObserverMethod::isAsync)) {
                    this.webBeansContext.getNotificationManager().getDefaultNotificationOptions().getExecutor().execute(() -> {});
                }
                this.fireAfterDeploymentValidationEvent();
                scanner.release();
                this.webBeansContext.getAnnotatedElementFactory().clear();
                this.webBeansContext.getNotificationManager().clearCaches();
                this.webBeansContext.getAnnotationManager().clearCaches();
            }
        }
        catch (UnsatisfiedResolutionException e) {
            throw new WebBeansDeploymentException(e);
        }
        catch (AmbiguousResolutionException e) {
            throw new WebBeansDeploymentException(e);
        }
        catch (UnproxyableResolutionException e) {
            throw new WebBeansDeploymentException(e);
        }
        catch (IllegalArgumentException e) {
            throw new WebBeansConfigurationException(e);
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
        finally {
            this.deployed = true;
        }
    }

    private void validateNames() {
        HashSet<String> names = new HashSet<String>();
        HashSet<String> partials = new HashSet<String>();
        for (Bean<?> bean : this.webBeansContext.getBeanManagerImpl().getBeans()) {
            String name;
            if (bean.isAlternative() || AbstractProducerBean.class.isInstance(bean) && ((AbstractProducerBean)AbstractProducerBean.class.cast(bean)).getOwnerComponent().isAlternative() || (name = bean.getName()) == null) continue;
            if (name.contains(".")) {
                String[] segments = name.split("\\.");
                String current = "";
                for (int i = 0; i < segments.length - 1; ++i) {
                    current = current + (i > 0 ? "." : "") + segments[i];
                    partials.add(current);
                    if (!names.contains(current)) continue;
                    throw new WebBeansDeploymentException("Name '" + name + "' is conflicting with '" + current + "'");
                }
            }
            if (names.add(name) && !partials.contains(name)) continue;
            throw new WebBeansDeploymentException("Name '" + name + "' is conflicting");
        }
    }

    private Map<BeanArchiveService.BeanArchiveInformation, Map<AnnotatedType<?>, ExtendedBeanAttributes<?>>> getBeanAttributes(Map<BeanArchiveService.BeanArchiveInformation, List<AnnotatedType<?>>> annotatedTypesPerBda) {
        HashMap beanAttributesPerBda = new HashMap();
        for (Map.Entry<BeanArchiveService.BeanArchiveInformation, List<AnnotatedType<?>>> atEntry : annotatedTypesPerBda.entrySet()) {
            BeanArchiveService.BeanArchiveInformation bdaInfo = atEntry.getKey();
            List<AnnotatedType<?>> annotatedTypes = atEntry.getValue();
            boolean onlyScopedBeans = BeanArchiveService.BeanDiscoveryMode.TRIM == bdaInfo.getBeanDiscoveryMode();
            IdentityHashMap bdaBeanAttributes = new IdentityHashMap(annotatedTypes.size());
            Iterator<AnnotatedType<?>> iterator = annotatedTypes.iterator();
            while (iterator.hasNext()) {
                AnnotatedType<?> at = iterator.next();
                Class beanClass = at.getJavaClass();
                boolean isEjb = this.discoverEjb && EJBWebBeansConfigurator.isSessionBean(beanClass, this.webBeansContext);
                try {
                    if (isEjb || (ClassUtil.isConcrete(beanClass) || WebBeansUtil.isDecorator(at)) && this.isValidManagedBean(at)) {
                        ProcessBeanAttributesImpl<?> processBeanAttributes;
                        BeanAttributesImpl<?> beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(at, onlyScopedBeans && !isEjb).build();
                        if (beanAttributes == null || beanAttributes.isAlternative() && !this.isEnabledAlternative(at, beanAttributes.getStereotypes()) || (processBeanAttributes = this.webBeansContext.getWebBeansUtil().fireProcessBeanAttributes((Annotated)at, at.getJavaClass(), beanAttributes)) == null) continue;
                        BeanAttributes<?> newBeanAttributes = processBeanAttributes.getAttributes();
                        if (beanAttributes != newBeanAttributes) {
                            for (Class stereotype : newBeanAttributes.getStereotypes()) {
                                if (this.webBeansContext.getBeanManagerImpl().isStereotype(stereotype)) continue;
                                throw new WebBeansConfigurationException("Custom BeanAttributes#getStereotypes() must only contain Stereotypes!");
                            }
                        }
                        bdaBeanAttributes.put(at, new ExtendedBeanAttributes(newBeanAttributes, isEjb, processBeanAttributes.isIgnoreFinalMethods()));
                        continue;
                    }
                    iterator.remove();
                }
                catch (NoClassDefFoundError ncdfe) {
                    logger.info("Skipping deployment of Class " + beanClass + "due to a NoClassDefFoundError: " + ncdfe.getMessage());
                }
            }
            beanAttributesPerBda.put(bdaInfo, bdaBeanAttributes);
        }
        return beanAttributesPerBda;
    }

    private boolean isEnabledAlternative(AnnotatedType<?> at, Set<Class<? extends Annotation>> stereotypes) {
        AlternativesManager alternativesManager = this.webBeansContext.getAlternativesManager();
        if (alternativesManager.isAlternative(at.getJavaClass(), stereotypes)) {
            return true;
        }
        if (stereotypes != null && !stereotypes.isEmpty() && at.getAnnotations(Priority.class) != null) {
            for (Class<? extends Annotation> stereotype : stereotypes) {
                if (!alternativesManager.isAlternativeStereotype(stereotype)) continue;
                return true;
            }
        }
        return false;
    }

    private void validateDisposeParameters() {
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        for (Bean<?> bean : this.webBeansContext.getBeanManagerImpl().getBeans()) {
            BaseProducerProducer producerProducer;
            Set<InjectionPoint> disposalIPs;
            Producer producer;
            if (!ProducerMethodBean.class.isInstance(bean) || !BaseProducerProducer.class.isInstance(producer = ((AbstractProducerBean)AbstractProducerBean.class.cast(bean)).getProducer()) || (disposalIPs = (producerProducer = (BaseProducerProducer)BaseProducerProducer.class.cast(producer)).getDisposalIPs()) == null || producerProducer.isAnyDisposal()) continue;
            webBeansUtil.validate(disposalIPs, bean);
        }
    }

    private void validateDecoratorDecoratedTypes() {
        for (Decorator<?> decorator : this.decoratorsManager.getDecorators()) {
            if (!decorator.getDecoratedTypes().isEmpty()) continue;
            throw new WebBeansConfigurationException("Decorator must implement at least one interface (java.io.Serializeable will be ignored)");
        }
    }

    private void validateDecoratorGenericTypes() {
        for (Decorator<?> decorator : this.decoratorsManager.getDecorators()) {
            Type type = decorator.getDelegateType();
            HashSet<Type> types = new HashSet<Type>();
            if (Class.class.isInstance(type)) {
                for (Class c = (Class)Class.class.cast(type); c != Object.class && c != null; c = c.getSuperclass()) {
                    types.add(c);
                    for (Type t : Arrays.asList(c.getGenericInterfaces())) {
                        if (!ParameterizedType.class.isInstance(t)) continue;
                        types.add(t);
                    }
                    Type genericSuperclass = c.getGenericSuperclass();
                    if (!ParameterizedType.class.isInstance(genericSuperclass)) continue;
                    types.add(genericSuperclass);
                }
            }
            for (Type api : decorator.getTypes()) {
                if (!ParameterizedType.class.isInstance(api)) continue;
                ParameterizedType pt1 = (ParameterizedType)ParameterizedType.class.cast(api);
                for (Type t : types) {
                    if (!ParameterizedType.class.isInstance(t)) continue;
                    ParameterizedType pt2 = (ParameterizedType)ParameterizedType.class.cast(t);
                    if (pt1.getRawType() != pt2.getRawType() || GenericsUtil.isAssignableFrom(true, false, (Type)pt1, (Type)pt2, new HashMap<Type, Integer>())) continue;
                    throw new WebBeansConfigurationException("Generic error matching " + api + " and " + t);
                }
            }
        }
    }

    private void removeDisabledBeans() {
        Iterator<Bean<?>> beans = this.webBeansContext.getBeanManagerImpl().getBeans().iterator();
        while (beans.hasNext()) {
            Bean<?> bean = beans.next();
            if (((OwbBean)bean).isEnabled()) continue;
            beans.remove();
        }
    }

    private void registerAlternativesDecoratorsAndInterceptorsWithPriority(List<AnnotatedType<?>> annotatedTypes) {
        AlternativesManager alternativesManager = this.webBeansContext.getAlternativesManager();
        for (AnnotatedType<?> annotatedType : annotatedTypes) {
            Class javaClass;
            Priority priority;
            if (annotatedType.getAnnotation(Alternative.class) != null && (priority = (Priority)annotatedType.getAnnotation(Priority.class)) != null) {
                alternativesManager.addPriorityClazzAlternative(annotatedType.getJavaClass(), priority);
            }
            if (annotatedType.getAnnotation(Interceptor.class) != null && (priority = (Priority)annotatedType.getAnnotation(Priority.class)) != null) {
                javaClass = annotatedType.getJavaClass();
                this.interceptorsManager.addPriorityClazzInterceptor(javaClass, priority);
            }
            if (annotatedType.getAnnotation(javax.decorator.Decorator.class) == null || (priority = (Priority)annotatedType.getAnnotation(Priority.class)) == null) continue;
            javaClass = annotatedType.getJavaClass();
            this.decoratorsManager.addPriorityClazzDecorator(javaClass, priority);
        }
    }

    private void configureDefaultBeans() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        beanManager.addInternalBean(webBeansUtil.getInterceptionFactoryBean());
        beanManager.addInternalBean(webBeansUtil.getConversationBean());
        beanManager.addInternalBean(webBeansUtil.getInjectionPointBean());
        beanManager.addInternalBean(webBeansUtil.getInstanceBean());
        beanManager.addInternalBean(webBeansUtil.getEventBean());
        beanManager.addInternalBean(webBeansUtil.getEventMetadataBean());
        beanManager.addInternalBean(webBeansUtil.getBeanMetadataBean());
        beanManager.addInternalBean(webBeansUtil.getInterceptorMetadataBean());
        beanManager.addInternalBean(webBeansUtil.getDecoratorMetadataBean());
        beanManager.addInternalBean(webBeansUtil.getInterceptedOrDecoratedBeanMetadataBean());
        beanManager.addInternalBean(webBeansUtil.getPrincipalBean());
        OpenWebBeansJavaEEPlugin beanEeProvider = this.webBeansContext.getPluginLoader().getJavaEEPlugin();
        if (beanEeProvider != null) {
            beanEeProvider.registerEEBeans();
        }
    }

    private void addDefaultBean(WebBeansContext ctx, String className) {
        Bean bean = null;
        Class<?> beanClass = ClassUtil.getClassFromName(className);
        if (beanClass != null) {
            bean = (Bean)this.newInstance(ctx, beanClass);
        }
        if (bean != null) {
            ctx.getBeanManagerImpl().addInternalBean(bean);
        }
    }

    private Object newInstance(WebBeansContext wbc, Class<?> clazz) {
        try {
            if (System.getSecurityManager() != null) {
                Constructor c = this.webBeansContext.getSecurityService().doPrivilegedGetConstructor(clazz, new Class[]{WebBeansContext.class});
                if (c == null) {
                    return this.webBeansContext.getSecurityService().doPrivilegedObjectCreate(clazz);
                }
                return c.newInstance(wbc);
            }
            if (clazz.getConstructors().length > 0) {
                try {
                    return clazz.getConstructor(WebBeansContext.class).newInstance(wbc);
                }
                catch (Exception e) {
                    return clazz.newInstance();
                }
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof PrivilegedActionException) {
                cause = e.getCause();
            }
            String error = "Error occurred while creating an instance of class : " + clazz.getName();
            logger.log(Level.SEVERE, error, cause);
            throw new WebBeansException(error, cause);
        }
    }

    private void fireBeforeBeanDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        BeforeBeanDiscoveryImpl event = new BeforeBeanDiscoveryImpl(this.webBeansContext);
        manager.fireLifecycleEvent(event, new Annotation[0]);
        for (AnnotatedTypeConfiguratorHolder annotatedTypeConfiguratorHolder : event.getAnnotatedTypeConfigurators()) {
            manager.addAdditionalAnnotatedType(annotatedTypeConfiguratorHolder.getExtension(), annotatedTypeConfiguratorHolder.getAnnotatedTypeConfigurator().getNewAnnotatedType(), annotatedTypeConfiguratorHolder.getId());
        }
        for (AnnotatedTypeConfiguratorImpl annotatedTypeConfiguratorImpl : event.getInterceptorBindingConfigurators()) {
            this.webBeansContext.getInterceptorsManager().addInterceptorBindingType(annotatedTypeConfiguratorImpl.getNewAnnotatedType());
        }
        for (AnnotatedTypeConfiguratorImpl annotatedTypeConfiguratorImpl : event.getQualifierConfigurators()) {
            this.webBeansContext.getBeanManagerImpl().addAdditionalQualifier(annotatedTypeConfiguratorImpl.getNewAnnotatedType());
        }
        event.setStarted();
    }

    private void fireAfterBeanDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.setAfterBeanDiscoveryStart();
        AfterBeanDiscoveryImpl event = new AfterBeanDiscoveryImpl(this.webBeansContext);
        manager.fireLifecycleEvent(event, new Annotation[0]);
        event.deployConfiguredBeans();
        this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by AfterBeanDiscovery event observers. Look at logs for further details");
        manager.setAfterBeanDiscoveryDone();
        event.setStarted();
    }

    private List<AnnotatedType<?>> fireAfterTypeDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        LinkedList newAt = new LinkedList();
        List<Class<?>> interceptors = this.interceptorsManager.getPrioritizedInterceptors();
        List<Class<?>> decorators = this.decoratorsManager.getPrioritizedDecorators();
        List<Class<?>> alternatives = this.webBeansContext.getAlternativesManager().getPrioritizedAlternatives();
        Collections.reverse(interceptors);
        Collections.reverse(decorators);
        Collections.reverse(alternatives);
        AfterTypeDiscoveryImpl event = new AfterTypeDiscoveryImpl(this.webBeansContext, newAt, interceptors, decorators, alternatives);
        manager.fireLifecycleEvent(event, new Annotation[0]);
        Collections.reverse(alternatives);
        for (AnnotatedTypeConfiguratorHolder holder : event.getAnnotatedTypeConfigurators()) {
            AnnotatedTypeImpl at = holder.getAnnotatedTypeConfigurator().getNewAnnotatedType();
            manager.addAdditionalAnnotatedType(holder.getExtension(), at, holder.getId());
            newAt.add(at);
        }
        event.setStarted();
        this.webBeansContext.getWebBeansUtil().inspectDeploymentErrorStack("There are errors that are added by AfterTypeDiscovery event observers. Look at logs for further details");
        return newAt;
    }

    private void fireAfterDeploymentValidationEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.setAfterDeploymentValidationFired(true);
        AfterDeploymentValidationImpl event = new AfterDeploymentValidationImpl(manager);
        manager.fireLifecycleEvent(event, new Annotation[0]);
        this.webBeansContext.getWebBeansUtil().inspectDeploymentErrorStack("There are errors that are added by AfterDeploymentValidation event observers. Look at logs for further details");
        this.packageVetoCache.clear();
        event.setStarted();
    }

    private void validateAlternatives(Map<BeanArchiveService.BeanArchiveInformation, Map<AnnotatedType<?>, ExtendedBeanAttributes<?>>> beanAttributesPerBda) {
        Set<Class<?>> xmlConfiguredAlternatives = this.webBeansContext.getAlternativesManager().getXmlConfiguredAlternatives();
        InjectionResolver injectionResolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
        for (Class<?> alternativeClass : xmlConfiguredAlternatives) {
            boolean foundAlternativeClass;
            block6: {
                if (AnnotationUtil.hasClassAnnotation(alternativeClass, Alternative.class) || AnnotationUtil.hasMetaAnnotation(alternativeClass.getAnnotations(), Alternative.class) || this.hasAlternativeProducerMethod(alternativeClass)) continue;
                foundAlternativeClass = false;
                Set<Bean<?>> beans = injectionResolver.implResolveByType(false, alternativeClass, new Annotation[]{AnyLiteral.INSTANCE});
                if (beans == null || beans.isEmpty()) {
                    for (Map<AnnotatedType<?>, ExtendedBeanAttributes<?>> map : beanAttributesPerBda.values()) {
                        for (Map.Entry<AnnotatedType<?>, ExtendedBeanAttributes<?>> exType : map.entrySet()) {
                            if (!alternativeClass.equals(exType.getKey().getJavaClass()) || !((ExtendedBeanAttributes)exType.getValue()).beanAttributes.isAlternative() && exType.getKey().getAnnotation(Alternative.class) == null) continue;
                            foundAlternativeClass = true;
                            break block6;
                        }
                    }
                } else {
                    for (Bean bean : beans) {
                        if (!bean.isAlternative()) continue;
                        foundAlternativeClass = true;
                        break;
                    }
                }
            }
            if (foundAlternativeClass) continue;
            throw new WebBeansDeploymentException("Given alternative class : " + alternativeClass.getName() + " is not annotated wih @Alternative or not an enabled bean");
        }
    }

    private boolean hasAlternativeProducerMethod(Class<?> alternativeClass) {
        List<Method> nonPrivateMethods = ClassUtil.getNonPrivateMethods(alternativeClass, true);
        for (Method method : nonPrivateMethods) {
            if (method.getAnnotation(Alternative.class) == null && !AnnotationUtil.hasMetaAnnotation(method.getAnnotations(), Alternative.class) || method.getAnnotation(Produces.class) == null) continue;
            return true;
        }
        return false;
    }

    public void configureProducerMethodSpecializations() {
        Set<Bean<?>> beans = this.webBeansContext.getBeanManagerImpl().getBeans();
        List<ProducerMethodBean> producerMethodBeans = beans.stream().filter(ProducerMethodBean.class::isInstance).map(ProducerMethodBean.class::cast).collect(Collectors.toList());
        this.checkSpecializedProducerMethodConditions(producerMethodBeans);
        for (int i = 0; i < producerMethodBeans.size(); ++i) {
            ProducerMethodBean producerMethodBean = producerMethodBeans.get(i);
            if (!producerMethodBean.isEnabled()) continue;
            for (int j = 0; j < producerMethodBeans.size(); ++j) {
                ProducerMethodBean otherProducerMethodBean = producerMethodBeans.get(j);
                if (i == j || !otherProducerMethodBean.isEnabled() || producerMethodBean.getBeanClass().equals(otherProducerMethodBean.getBeanClass()) || !otherProducerMethodBean.getBeanClass().isAssignableFrom(producerMethodBean.getBeanClass()) || !producerMethodBean.getCreatorMethod().getName().equals(otherProducerMethodBean.getCreatorMethod().getName())) continue;
                otherProducerMethodBean.setEnabled(false);
            }
        }
    }

    private void checkSpecializedProducerMethodConditions(List<ProducerMethodBean> producerBeans) {
        HashSet<String> methodsDisabledDueToSpecialization = new HashSet<String>();
        for (ProducerMethodBean producerBean : producerBeans) {
            if (!producerBean.isSpecializedBean()) continue;
            Method creatorMethod = producerBean.getCreatorMethod();
            Method overloadedMethod = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(creatorMethod.getDeclaringClass().getSuperclass(), creatorMethod.getName(), (Class[])creatorMethod.getParameterTypes());
            if (overloadedMethod == null) {
                throw new WebBeansConfigurationException("Annotated producer method specialization failed : " + creatorMethod.getName() + " not found in super class : " + creatorMethod.getDeclaringClass().getSuperclass().getName() + " for annotated method : " + creatorMethod);
            }
            if (!AnnotationUtil.hasAnnotation(creatorMethod.getAnnotations(), Produces.class)) {
                throw new WebBeansConfigurationException("Annotated producer method specialization failed : " + creatorMethod.getName() + " found in super class : " + creatorMethod.getDeclaringClass().getSuperclass().getName() + " is not annotated with @Produces for annotated method : " + creatorMethod);
            }
            String superMethod = overloadedMethod.toString();
            if (methodsDisabledDueToSpecialization.contains(superMethod)) {
                throw new WebBeansDeploymentException("Multiple specializations for the same producer method got detected for type" + producerBean);
            }
            methodsDisabledDueToSpecialization.add(superMethod);
        }
    }

    private void validateInjectionPoints() {
        logger.fine("Validation of injection points has started.");
        this.decoratorsManager.validateDecoratorClasses();
        this.interceptorsManager.validateInterceptorClasses();
        Set<Decorator<?>> decorators = this.decoratorsManager.getDecorators();
        logger.fine("Validation of the decorator's injection points has started.");
        this.validate(decorators);
        List<javax.enterprise.inject.spi.Interceptor<?>> interceptors = this.interceptorsManager.getCdiInterceptors();
        logger.fine("Validation of the interceptor's injection points has started.");
        this.validate(interceptors);
        logger.fine("Validation of the beans' injection points has started.");
        Set<Bean<?>> beans = this.webBeansContext.getBeanManagerImpl().getBeans();
        this.validate(beans);
        logger.fine("Validation of the observer methods' injection points has started.");
        this.validateObservers(this.webBeansContext.getNotificationManager().getObserverMethods());
        logger.info("INFO_0003");
    }

    private <T, B extends Bean<?>> void validate(Collection<B> beans) {
        this.webBeansContext.getBeanManagerImpl().getInjectionResolver().clearCaches();
        if (beans != null && beans.size() > 0) {
            LinkedList<String> beanNames = new LinkedList<String>();
            for (Bean bean : beans) {
                try {
                    Set injectionPoints;
                    AbstractProducer producer;
                    if (bean instanceof OwbBean && !((OwbBean)bean).isEnabled()) continue;
                    if (bean.getBeanClass().getName().startsWith(JAVAX_ENTERPRISE_PACKAGE)) {
                        Class<?> proxyable;
                        if (!BuiltInOwbBean.class.isInstance(bean) || (proxyable = ((BuiltInOwbBean)BuiltInOwbBean.class.cast(bean)).proxyableType()) == null) continue;
                        producer = (InjectionTargetImpl<?>)AbstractProducer.class.cast(((OwbBean)OwbBean.class.cast(bean)).getProducer());
                        AnnotatedType<?> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(proxyable);
                        producer.defineInterceptorStack(bean, annotatedType, this.webBeansContext);
                        continue;
                    }
                    String beanName = bean.getName();
                    if (beanName != null) {
                        beanNames.push(beanName);
                    }
                    if (bean instanceof OwbBean && !(bean instanceof javax.enterprise.inject.spi.Interceptor) && !(bean instanceof Decorator)) {
                        producer = null;
                        OwbBean owbBean = (OwbBean)bean;
                        if (ManagedBean.class.isInstance(bean)) {
                            producer = ((ManagedBean)ManagedBean.class.cast(bean)).getOriginalInjectionTarget();
                        }
                        if (producer == null && owbBean.getProducer() instanceof AbstractProducer) {
                            producer = (AbstractProducer)owbBean.getProducer();
                        }
                        if (producer != null) {
                            AnnotatedType annotatedType = owbBean instanceof InjectionTargetBean ? ((InjectionTargetBean)owbBean).getAnnotatedType() : this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(owbBean.getReturnType());
                            producer.defineInterceptorStack(owbBean, annotatedType, this.webBeansContext);
                        }
                    }
                    if ((injectionPoints = bean.getInjectionPoints()) != null) {
                        this.webBeansContext.getWebBeansUtil().validate(injectionPoints, bean);
                    }
                    this.checkPassivationScope(bean);
                }
                catch (RuntimeException e) {
                    throw ExceptionUtil.addInformation(e, "Problem while validating bean " + bean);
                }
            }
            this.validateBeanNames(beanNames);
            beanNames.clear();
        }
    }

    private void validateObservers(Collection<ObserverMethod<?>> observerMethods) {
        for (ObserverMethod<?> observerMethod : observerMethods) {
            if (!(observerMethod instanceof OwbObserverMethod)) continue;
            OwbObserverMethod owbObserverMethod = (OwbObserverMethod)observerMethod;
            this.webBeansContext.getWebBeansUtil().validate(owbObserverMethod.getInjectionPoints(), null);
        }
    }

    private void validateBeanNames(LinkedList<String> beanNames) {
        if (beanNames.size() > 0) {
            InjectionResolver resolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
            for (String beanName : beanNames) {
                for (String other : beanNames) {
                    String part = null;
                    int i = beanName.lastIndexOf(46);
                    if (i != -1) {
                        part = beanName.substring(0, i);
                    }
                    if (beanName.equals(other)) {
                        Set<Bean<?>> beans = resolver.implResolveByName(beanName);
                        if (beans.size() <= 1) continue;
                        try {
                            resolver.resolve(beans, null);
                        }
                        catch (AmbiguousResolutionException are) {
                            InjectionExceptionUtil.throwAmbiguousResolutionExceptionForBeanName(beans, beanName);
                        }
                        continue;
                    }
                    if (part == null || !part.equals(other)) continue;
                    throw new WebBeansDeploymentException("EL name of one bean is of the form x.y, where y is a valid bean EL name, and x is the EL name of the other bean for the bean name : " + beanName);
                }
            }
        }
    }

    private Map<BeanArchiveService.BeanArchiveInformation, List<AnnotatedType<?>>> annotatedTypesFromClassPath(ScannerService scanner) {
        logger.fine("Creating AnnotatedTypes from class files has started.");
        HashSet foundClasses = new HashSet(100);
        HashMap annotatedTypesPerBda = new HashMap();
        if (scanner instanceof BdaScannerService) {
            Map beanClassesPerBda = ((BdaScannerService)scanner).getBeanClassesPerBda();
            for (Map.Entry bdaEntry : beanClassesPerBda.entrySet()) {
                List<AnnotatedType<?>> annotatedTypes = this.annotatedTypesFromBdaClassPath((Set)bdaEntry.getValue(), foundClasses);
                annotatedTypesPerBda.put((BeanArchiveService.BeanArchiveInformation)bdaEntry.getKey(), annotatedTypes);
            }
            annotatedTypesPerBda.put(this.defaultBeanArchiveInformation, this.annotatedTypesFromBdaClassPath(scanner.getBeanClasses(), foundClasses));
        } else {
            Set classIndex = scanner.getBeanClasses();
            List<AnnotatedType<?>> annotatedTypes = this.annotatedTypesFromBdaClassPath(classIndex, foundClasses);
            annotatedTypesPerBda.put(this.defaultBeanArchiveInformation, annotatedTypes);
        }
        return annotatedTypesPerBda;
    }

    private List<AnnotatedType<?>> annotatedTypesFromBdaClassPath(Set<Class<?>> classIndex, Set<Class<?>> foundClasses) {
        ArrayList annotatedTypes = new ArrayList();
        if (classIndex != null) {
            AnnotatedElementFactory annotatedElementFactory = this.webBeansContext.getAnnotatedElementFactory();
            for (Class<?> implClass : classIndex) {
                AnnotatedType<?> annotatedType;
                if (foundClasses.contains(implClass)) continue;
                foundClasses.add(implClass);
                if (this.isVetoed(implClass)) {
                    if (!this.isEEComponent(implClass)) continue;
                    annotatedType = annotatedElementFactory.newAnnotatedType(implClass);
                    InjectionTarget<?> it = this.webBeansContext.getBeanManagerImpl().createInjectionTarget(annotatedType);
                    for (InjectionPoint ip : it.getInjectionPoints()) {
                        this.webBeansContext.getWebBeansUtil().fireProcessInjectionPointEvent(ip);
                    }
                    continue;
                }
                try {
                    annotatedType = annotatedElementFactory.getAnnotatedType(implClass);
                    if (annotatedType == null) {
                        annotatedType = annotatedElementFactory.newAnnotatedType(implClass);
                    }
                    if (annotatedType == null) {
                        logger.info("Could not create AnnotatedType for class " + implClass);
                        continue;
                    }
                    annotatedType.getJavaClass().getDeclaredMethods();
                    annotatedType.getJavaClass().getDeclaredFields();
                    if (!annotatedType.getJavaClass().isAnnotation()) {
                        GProcessAnnotatedType processAnnotatedEvent = this.webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent(annotatedType);
                        if (!processAnnotatedEvent.isVeto()) {
                            annotatedTypes.add(processAnnotatedEvent.getAnnotatedType());
                        }
                        processAnnotatedEvent.setStarted();
                        continue;
                    }
                    annotatedTypes.add(annotatedType);
                }
                catch (NoClassDefFoundError ncdfe) {
                    logger.info("Skipping deployment of Class " + implClass + "due to a NoClassDefFoundError: " + ncdfe.getMessage());
                }
            }
        }
        return annotatedTypes;
    }

    private boolean isEEComponent(Class<?> impl) {
        OpenWebBeansJavaEEPlugin eePlugin = this.webBeansContext.getPluginLoader().getJavaEEPlugin();
        return eePlugin != null && eePlugin.isEEComponent(impl);
    }

    private boolean isVetoed(Class<?> implClass) {
        Package pckge;
        if (implClass.getAnnotation(Vetoed.class) != null) {
            return true;
        }
        ClassLoader classLoader = implClass.getClassLoader();
        if (classLoader == null) {
            classLoader = BeansDeployer.class.getClassLoader();
        }
        if ((pckge = implClass.getPackage()) == null) {
            return false;
        }
        do {
            String name;
            Boolean result;
            if ((result = this.packageVetoCache.get(name = pckge.getName())) != null && result.booleanValue()) {
                return result;
            }
            if (pckge.getAnnotation(Vetoed.class) != null) {
                this.packageVetoCache.put(pckge.getName(), true);
                return true;
            }
            this.packageVetoCache.put(pckge.getName(), false);
            int idx = name.lastIndexOf(46);
            if (idx > 0) {
                String previousPackage = name.substring(0, idx);
                Boolean result2 = this.packageVetoCache.get(previousPackage);
                if (result2 != null && result2.booleanValue()) {
                    return result2;
                }
                try {
                    pckge = (Package)Package.class.cast(GET_PACKAGE.invoke((Object)classLoader, previousPackage));
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else {
                pckge = null;
            }
        } while (pckge != null);
        return false;
    }

    private void addAdditionalAnnotatedTypes(Collection<AnnotatedType<?>> toDeploy, List<AnnotatedType<?>> annotatedTypes) {
        for (AnnotatedType<?> annotatedType : toDeploy) {
            GProcessSyntheticAnnotatedType processAnnotatedEvent;
            GProcessSyntheticAnnotatedType gProcessSyntheticAnnotatedType = processAnnotatedEvent = !annotatedType.getJavaClass().isAnnotation() ? this.webBeansContext.getWebBeansUtil().fireProcessSyntheticAnnotatedTypeEvent(annotatedType) : null;
            if (processAnnotatedEvent == null || !processAnnotatedEvent.isVeto()) {
                Object changedAnnotatedType;
                Object object = changedAnnotatedType = processAnnotatedEvent == null ? annotatedType : processAnnotatedEvent.getAnnotatedType();
                if (annotatedTypes.contains(changedAnnotatedType)) {
                    annotatedTypes.remove(changedAnnotatedType);
                }
                annotatedTypes.add((AnnotatedType<?>)changedAnnotatedType);
            }
            if (processAnnotatedEvent == null) continue;
            processAnnotatedEvent.setStarted();
        }
    }

    protected void deployFromBeanAttributes(Map<BeanArchiveService.BeanArchiveInformation, Map<AnnotatedType<?>, ExtendedBeanAttributes<?>>> beanAttributesPerBda) {
        logger.fine("Deploying configurations from class files has started.");
        BeanManagerImpl bm = this.webBeansContext.getBeanManagerImpl();
        for (Map<AnnotatedType<?>, ExtendedBeanAttributes<?>> beanAttributesMap : beanAttributesPerBda.values()) {
            for (Map.Entry<AnnotatedType<?>, ExtendedBeanAttributes<?>> annotatedType : beanAttributesMap.entrySet()) {
                AnnotatedType<?> key = annotatedType.getKey();
                Collection userAnnotatedTypes = bm.getUserAnnotatedTypes(key.getJavaClass());
                if (userAnnotatedTypes != null && userAnnotatedTypes.stream().anyMatch(it -> it != key && AnnotatedTypeWrapper.class.isInstance(it) && ((AnnotatedTypeWrapper)AnnotatedTypeWrapper.class.cast(it)).getId().endsWith("OWB_DEFAULT_KEY") && it.getAnnotations().equals(key.getAnnotations()))) continue;
                try {
                    this.deploySingleAnnotatedType(key, annotatedType.getValue(), beanAttributesMap);
                }
                catch (NoClassDefFoundError ncdfe) {
                    logger.info("Skipping deployment of Class " + key.getJavaClass() + "due to a NoClassDefFoundError: " + ncdfe.getMessage());
                }
                bm.removeAdditionalAnnotatedType(key);
            }
        }
        logger.fine("Deploying configurations from class files has ended.");
    }

    private void deploySingleAnnotatedType(AnnotatedType annotatedType, ExtendedBeanAttributes annotatedTypeData, Map<AnnotatedType<?>, ExtendedBeanAttributes<?>> annotatedTypes) {
        Class beanClass = annotatedType.getJavaClass();
        if (annotatedTypeData.isEjb) {
            logger.log(Level.FINE, "Found Enterprise Bean with class name : [{0}]", beanClass.getName());
            this.defineEnterpriseWebBean(beanClass, annotatedType, annotatedTypeData.beanAttributes);
        } else {
            try {
                if ((ClassUtil.isConcrete(beanClass) || WebBeansUtil.isDecorator(annotatedType)) && this.isValidManagedBean(annotatedType)) {
                    this.defineManagedBean(annotatedType, annotatedTypeData, annotatedTypes);
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                logger.warning("Skipping deployment of Class " + beanClass + " due to a NoClassDefFoundError: " + ncdfe.getMessage());
            }
        }
    }

    private boolean isValidManagedBean(AnnotatedType<?> type) {
        Class beanClass = type.getJavaClass();
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        try {
            webBeansUtil.checkManagedBean(beanClass);
        }
        catch (DefinitionException e) {
            logger.log(Level.FINE, "skipped deployment of: " + beanClass.getName() + " reason: " + e.getMessage());
            logger.log(Level.FINER, "skipped deployment of: " + beanClass.getName() + " details: ", e);
            return false;
        }
        try {
            if (!webBeansUtil.isConstructorOk(type)) {
                return false;
            }
        }
        catch (TypeNotPresentException cnfe) {
            return false;
        }
        webBeansUtil.checkManagedBeanCondition(beanClass);
        return true;
    }

    protected void deployFromXML(ScannerService scanner) throws WebBeansDeploymentException {
        logger.fine("Deploying configurations from XML files has started.");
        Set bdaLocations = scanner.getBeanXmls();
        for (URL url : bdaLocations) {
            logger.fine("OpenWebBeans BeansDeployer configuring: " + url.toExternalForm());
            BeanArchiveService.BeanArchiveInformation beanArchiveInformation = this.beanArchiveService.getBeanArchiveInformation(url);
            this.configureDecorators(url, beanArchiveInformation.getDecorators());
            this.configureInterceptors(url, beanArchiveInformation.getInterceptors());
            this.configureAlternatives(url, beanArchiveInformation.getAlternativeClasses(), false);
            this.configureAlternatives(url, beanArchiveInformation.getAlternativeStereotypes(), true);
            this.configureAllowProxying(url, beanArchiveInformation.getAllowProxyingClasses());
        }
        logger.fine("Deploying configurations from XML has ended successfully.");
    }

    private void configureAlternatives(URL bdaLocation, List<String> alternatives, boolean isStereotype) {
        AlternativesManager manager = this.webBeansContext.getAlternativesManager();
        HashSet<String> alternativesInFile = new HashSet<String>();
        for (String alternativeName : alternatives) {
            if (alternativesInFile.contains(alternativeName)) {
                throw new WebBeansDeploymentException(this.createConfigurationFailedMessage(bdaLocation) + "Given alternative : " + alternativeName + " is already added as @Alternative");
            }
            alternativesInFile.add(alternativeName);
            Class<?> clazz = ClassUtil.getClassFromName(alternativeName);
            if (clazz == null) {
                throw new WebBeansDeploymentException(this.createConfigurationFailedMessage(bdaLocation) + "Alternative: " + alternativeName + " not found");
            }
            if (isStereotype) {
                manager.addXmlStereoTypeAlternative(clazz);
                continue;
            }
            manager.addXmlClazzAlternative(clazz);
        }
    }

    private void configureDecorators(URL bdaLocation, List<String> decorators) {
        HashSet decoratorsInFile = new HashSet();
        for (String decorator : decorators) {
            Class<?> clazz = ClassUtil.getClassFromName(decorator);
            if (clazz == null) {
                throw new WebBeansDeploymentException(this.createConfigurationFailedMessage(bdaLocation) + "Decorator class : " + decorator + " not found");
            }
            if (this.scannerService.isBDABeansXmlScanningEnabled() && !this.scannerService.getBDABeansXmlScanner().addDecorator(clazz, bdaLocation.toExternalForm()) || decoratorsInFile.contains(clazz)) {
                throw new WebBeansDeploymentException(this.createConfigurationFailedMessage(bdaLocation) + "Decorator class : " + decorator + " is already defined");
            }
            this.decoratorsManager.addEnabledDecorator(clazz);
            decoratorsInFile.add(clazz);
        }
    }

    private void configureInterceptors(URL bdaLocation, List<String> interceptors) {
        HashSet interceptorsInFile = new HashSet();
        for (String interceptor : interceptors) {
            GProcessAnnotatedType processAnnotatedEvent;
            Class<?> clazz = ClassUtil.getClassFromName(interceptor);
            if (clazz == null) {
                throw new WebBeansDeploymentException(this.createConfigurationFailedMessage(bdaLocation) + "Interceptor class : " + interceptor + " not found");
            }
            AnnotatedType annotatedType = this.webBeansContext.getAnnotatedElementFactory().getAnnotatedType(clazz);
            if (annotatedType == null) {
                annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(clazz);
            }
            if ((processAnnotatedEvent = this.webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent(annotatedType)).isVeto()) {
                return;
            }
            annotatedType = processAnnotatedEvent.getAnnotatedType();
            processAnnotatedEvent.setStarted();
            Set annTypeAnnotations = annotatedType.getAnnotations();
            Annotation[] classAnnotations = annTypeAnnotations != null ? annTypeAnnotations.toArray(new Annotation[annTypeAnnotations.size()]) : new Annotation[]{};
            if (AnnotationUtil.hasAnnotation(classAnnotations, Interceptor.class) && !this.webBeansContext.getAnnotationManager().hasInterceptorBindingMetaAnnotation(classAnnotations)) {
                throw new WebBeansDeploymentException(this.createConfigurationFailedMessage(bdaLocation) + "Interceptor class : " + interceptor + " must have at least one @InterceptorBinding");
            }
            if (interceptorsInFile.contains(clazz)) {
                throw new WebBeansDeploymentException(this.createConfigurationFailedMessage(bdaLocation) + "Interceptor class : " + interceptor + " already defined in this beans.xml file!");
            }
            interceptorsInFile.add(clazz);
            boolean isBDAScanningEnabled = this.scannerService.isBDABeansXmlScanningEnabled();
            if (!isBDAScanningEnabled && this.interceptorsManager.isInterceptorClassEnabled(clazz) || isBDAScanningEnabled && !this.scannerService.getBDABeansXmlScanner().addInterceptor(clazz, bdaLocation.toExternalForm())) {
                int priority = -1;
                if (!isBDAScanningEnabled) {
                    priority = this.interceptorsManager.getPriority(clazz);
                }
                logger.fine("Interceptor class : " + interceptor + " is already defined" + (priority >= 0 ? " with priority " + priority : ""));
                continue;
            }
            this.interceptorsManager.addEnabledInterceptorClass(clazz);
        }
    }

    private void configureAllowProxying(URL url, List<String> allowProxyingClasses) {
        OpenWebBeansConfiguration owbConfiguration = this.webBeansContext.getOpenWebBeansConfiguration();
        for (String allowProxyingClass : allowProxyingClasses) {
            owbConfiguration.addConfigListValue("javax.enterprise.inject.allowProxying.classes", allowProxyingClass);
        }
    }

    private String createConfigurationFailedMessage(URL bdaLocation) {
        return "WebBeans configuration defined in " + bdaLocation.toExternalForm() + " did fail. Reason is : ";
    }

    protected void checkPassivationScope(Bean<?> beanObj) {
        boolean validate = false;
        if (beanObj instanceof EnterpriseBeanMarker) {
            EnterpriseBeanMarker marker = (EnterpriseBeanMarker)beanObj;
            if (marker.isPassivationCapable()) {
                validate = true;
            }
        } else if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(beanObj.getScope())) {
            if (WebBeansUtil.getPassivationId(beanObj) == null && !(beanObj instanceof AbstractProducerBean)) {
                throw new WebBeansDeploymentException("Passivation scoped defined bean must be passivation capable, but bean : " + beanObj.toString() + " is not passivation capable");
            }
            validate = true;
        }
        if (validate) {
            this.webBeansContext.getDeploymentValidationService().validatePassivationCapable((OwbBean)beanObj);
        }
    }

    protected void checkStereoTypes(Map<BeanArchiveService.BeanArchiveInformation, Map<AnnotatedType<?>, ExtendedBeanAttributes<?>>> beanAttributesPerBda) {
        logger.fine("Checking StereoType constraints has started.");
        this.addDefaultStereoTypes();
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        StereoTypeManager stereoTypeManager = this.webBeansContext.getStereoTypeManager();
        HashSet<Class> verifiedStereotypes = new HashSet<Class>();
        for (Map<AnnotatedType<?>, ExtendedBeanAttributes<?>> annotatedTypeExtendedBeanAttributesMap : beanAttributesPerBda.values()) {
            for (ExtendedBeanAttributes<?> extendedBeanAttributes : annotatedTypeExtendedBeanAttributesMap.values()) {
                Set stereotypes = ((ExtendedBeanAttributes)extendedBeanAttributes).beanAttributes.getStereotypes();
                for (Class stereoClass : stereotypes) {
                    if (verifiedStereotypes.contains(stereoClass)) continue;
                    if (annotationManager.isStereoTypeAnnotation(stereoClass) && stereoTypeManager.getStereoTypeModel(stereoClass.getName()) == null) {
                        this.webBeansContext.getAnnotationManager().checkStereoTypeClass(stereoClass, stereoClass.getDeclaredAnnotations());
                        StereoTypeModel model = new StereoTypeModel(this.webBeansContext, stereoClass);
                        stereoTypeManager.addStereoTypeModel(model);
                    }
                    verifiedStereotypes.add(stereoClass);
                }
            }
        }
        logger.fine("Checking StereoType constraints has ended.");
    }

    protected void addDefaultStereoTypes() {
        StereoTypeModel model = new StereoTypeModel(this.webBeansContext, Model.class);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel(model);
    }

    protected <T> void defineManagedBean(AnnotatedType<T> annotatedType, ExtendedBeanAttributes extendedBeanAttributes, Map<AnnotatedType<?>, ExtendedBeanAttributes<?>> annotatedTypes) {
        BeanAttributes attributes = extendedBeanAttributes.beanAttributes;
        Class beanClass = annotatedType.getJavaClass();
        if (this.webBeansContext.getWebBeansUtil().supportsJavaEeComponentInjections(beanClass)) {
            this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEventForJavaEeComponents(beanClass).setStarted();
            this.webBeansContext.getWebBeansUtil().inspectDeploymentErrorStack("There are errors that are added by ProcessInjectionTarget event observers. Look at logs for further details");
            this.webBeansContext.getAnnotationManager().checkInjectionPointForInjectInjectionPoint(beanClass);
        }
        ManagedBeanBuilder managedBeanCreator = new ManagedBeanBuilder(this.webBeansContext, annotatedType, attributes, extendedBeanAttributes.ignoreFinalMethods);
        if (WebBeansUtil.isDecorator(annotatedType)) {
            DecoratorBeanBuilder<T> dbb;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found Managed Bean Decorator with class name : [{0}]", annotatedType.getJavaClass().getName());
            }
            if ((dbb = new DecoratorBeanBuilder<T>(this.webBeansContext, annotatedType, attributes)).isDecoratorEnabled()) {
                dbb.defineDecoratorRules();
                DecoratorBean<T> decorator = dbb.getBean();
                GProcessBean processBeanEvent = new GProcessBean(decorator, annotatedType);
                this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processBeanEvent, true, new Annotation[0]);
                processBeanEvent.setStarted();
                this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by ProcessBean event observers for interceptor beans. Look at logs for further details");
                this.decoratorsManager.addDecorator(decorator);
            }
        } else if (WebBeansUtil.isCdiInterceptor(annotatedType)) {
            CdiInterceptorBeanBuilder<T> ibb;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found Managed Bean Interceptor with class name : [{0}]", annotatedType.getJavaClass().getName());
            }
            if ((ibb = new CdiInterceptorBeanBuilder<T>(this.webBeansContext, annotatedType, attributes)).isInterceptorEnabled()) {
                ibb.defineCdiInterceptorRules();
                CdiInterceptorBean interceptor = (CdiInterceptorBean)ibb.getBean();
                GProcessBean processBeanEvent = new GProcessBean(interceptor, annotatedType);
                this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processBeanEvent, true, new Annotation[0]);
                processBeanEvent.setStarted();
                this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by ProcessBean event observers for interceptor beans. Look at logs for further details");
                this.interceptorsManager.addCdiInterceptor(interceptor);
            }
        } else {
            Object priority;
            Object bean = managedBeanCreator.getBean();
            if (this.decoratorsManager.containsCustomDecoratorClass(annotatedType.getJavaClass()) || this.interceptorsManager.containsCustomInterceptorClass(annotatedType.getJavaClass())) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found Managed Bean with class name : [{0}]", annotatedType.getJavaClass().getName());
            }
            AnnotatedType beanAnnotatedType = ((InjectionTargetBean)bean).getAnnotatedType();
            Set<Object> observerMethods = ((AbstractOwbBean)bean).isEnabled() ? new ObserverMethodsBuilder(this.webBeansContext, beanAnnotatedType).defineObserverMethods(bean) : new HashSet();
            WebBeansContext wbc = ((AbstractOwbBean)bean).getWebBeansContext();
            Set<ProducerFieldBean<?>> producerFields = new ProducerFieldBeansBuilder(wbc, beanAnnotatedType).defineProducerFields(bean);
            Set<ProducerMethodBean<?>> producerMethods = new ProducerMethodBeansBuilder(wbc, beanAnnotatedType).defineProducerMethods(bean, producerFields);
            ManagedBean managedBean = (ManagedBean)bean;
            HashMap annotatedMethods = new HashMap();
            if (!(producerFields.isEmpty() && producerMethods.isEmpty() || (priority = (Priority)annotatedType.getAnnotation(Priority.class)) == null || this.webBeansContext.getAlternativesManager().isAlternative(annotatedType.getJavaClass(), Collections.emptySet()))) {
                this.webBeansContext.getAlternativesManager().addPriorityClazzAlternative(annotatedType.getJavaClass(), (Priority)priority);
            }
            for (ProducerMethodBean producerMethodBean : producerMethods) {
                AnnotatedMethod<T> annotatedMethod = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(producerMethodBean.getCreatorMethod(), annotatedType);
                this.webBeansContext.getWebBeansUtil().inspectDeploymentErrorStack("There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
                annotatedMethods.put(producerMethodBean, annotatedMethod);
            }
            HashMap annotatedFields = new HashMap();
            for (ProducerFieldBean<?> producerFieldBean : producerFields) {
                this.webBeansContext.getWebBeansUtil().inspectDeploymentErrorStack("There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
                annotatedFields.put(producerFieldBean, this.webBeansContext.getAnnotatedElementFactory().newAnnotatedField(producerFieldBean.getCreatorField(), this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(producerFieldBean.getBeanClass())));
            }
            HashMap hashMap = new HashMap();
            for (ObserverMethod observerMethod : observerMethods) {
                ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
                AnnotatedMethod annotatedMethod = impl.getObserverMethod();
                hashMap.put(observerMethod, annotatedMethod);
            }
            BeanManagerImpl beanManagerImpl = this.webBeansContext.getBeanManagerImpl();
            GProcessManagedBean gProcessManagedBean = new GProcessManagedBean((ManagedBean<?>)managedBean, annotatedType);
            beanManagerImpl.fireEvent((Object)gProcessManagedBean, true, new Annotation[0]);
            gProcessManagedBean.setStarted();
            this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by ProcessManagedBean event observers for managed beans. Look at logs for further details");
            this.webBeansContext.getWebBeansUtil().fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
            this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
            this.webBeansContext.getWebBeansUtil().fireProcessProducerFieldBeanEvent(annotatedFields);
            this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
            if (!this.webBeansContext.getWebBeansUtil().isAnnotatedTypeDecoratorOrInterceptor(annotatedType)) {
                beanManagerImpl.addBean((Bean<?>)bean);
                for (ProducerMethodBean<?> producerMethodBean : producerMethods) {
                    beanManagerImpl.addBean(producerMethodBean);
                }
                for (ProducerFieldBean producerFieldBean : producerFields) {
                    beanManagerImpl.addBean(producerFieldBean);
                }
            }
        }
    }

    protected <T> void defineEnterpriseWebBean(Class<T> clazz, AnnotatedType<T> annotatedType, BeanAttributes<T> attributes) {
        InjectionTargetBean bean = (InjectionTargetBean)EJBWebBeansConfigurator.defineEjbBean(clazz, annotatedType, attributes, this.webBeansContext);
        this.webBeansContext.getWebBeansUtil().setInjectionTargetBeanEnableFlag(bean);
    }

    static {
        Method getPackage;
        logger = WebBeansLoggerFacade.getLogger(BeansDeployer.class);
        try {
            getPackage = ClassLoader.class.getDeclaredMethod("getDefinedPackage", String.class);
            getPackage.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            try {
                getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                getPackage.setAccessible(true);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(ex);
            }
        }
        GET_PACKAGE = getPackage;
    }

    public static class ExtendedBeanAttributes<T> {
        private final BeanAttributes<T> beanAttributes;
        private final boolean isEjb;
        private final boolean ignoreFinalMethods;

        public ExtendedBeanAttributes(BeanAttributes<T> beanAttributes, boolean isEjb, boolean ignoreFinalMethods) {
            this.beanAttributes = beanAttributes;
            this.isEjb = isEjb;
            this.ignoreFinalMethods = ignoreFinalMethods;
        }
    }
}

