/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.ObserverMethodConfiguratorImpl;
import org.apache.webbeans.portable.events.EventBase;
import org.apache.webbeans.portable.events.discovery.ExtensionAware;

public class ProcessObserverMethodImpl<T, X>
extends EventBase
implements ProcessObserverMethod<T, X>,
ExtensionAware {
    private final WebBeansContext webBeansContext;
    private final AnnotatedMethod<X> annotatedMethod;
    private ObserverMethod<T> observerMethod;
    private boolean vetoed;
    private ObserverMethodConfiguratorImpl observerMethodConfigurator;
    private Extension extension;

    public ProcessObserverMethodImpl(WebBeansContext webBeansContext, AnnotatedMethod<X> annotatedMethod, ObserverMethod<T> observerMethod) {
        this.webBeansContext = webBeansContext;
        this.annotatedMethod = annotatedMethod;
        this.observerMethod = observerMethod;
    }

    @Override
    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public void addDefinitionError(Throwable t) {
        this.checkState();
        WebBeansContext.getInstance().getBeanManagerImpl().getErrorStack().pushError(t);
    }

    public ObserverMethodConfigurator<T> configureObserverMethod() {
        if (this.observerMethodConfigurator == null) {
            this.observerMethodConfigurator = new ObserverMethodConfiguratorImpl<T>(this.webBeansContext, this.extension, this.observerMethod);
        }
        return this.observerMethodConfigurator;
    }

    public AnnotatedMethod<X> getAnnotatedMethod() {
        this.checkState();
        return this.annotatedMethod;
    }

    public ObserverMethod<T> getObserverMethod() {
        this.checkState();
        if (this.observerMethodConfigurator != null) {
            return this.observerMethodConfigurator.getObserverMethod();
        }
        return this.observerMethod;
    }

    public void setObserverMethod(ObserverMethod<T> observerMethod) {
        this.checkState();
        this.observerMethod = observerMethod;
        this.observerMethodConfigurator = null;
    }

    public void veto() {
        this.checkState();
        this.vetoed = true;
    }

    public boolean isVetoed() {
        return this.vetoed;
    }
}

