/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.SessionBeanType;
import javax.interceptor.Interceptor;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;

public final class EjbValidator {
    private EjbValidator() {
    }

    public static void validateEjbScopeType(BaseEjbBean<?> ejbBean) {
        Asserts.assertNotNull(ejbBean, (String)"Session Bean");
        if (ejbBean.getScope() == null) {
            throw new NullPointerException("Session Bean scope can not be null");
        }
        if (ejbBean.getEjbType() == null) {
            throw new NullPointerException("Session Bean type can not be null. It must be one of @Stateless, @Stateful, @Singleton");
        }
        if (ejbBean.getEjbType() == SessionBeanType.STATELESS) {
            if (!ejbBean.getScope().equals(Dependent.class)) {
                throw new WebBeansConfigurationException("Stateless Session Bean class : " + ejbBean.getReturnType() + " can not define scope other than @Dependent");
            }
        } else if (ejbBean.getEjbType() == SessionBeanType.SINGLETON && !ejbBean.getScope().equals(Dependent.class) && !ejbBean.getScope().equals(ApplicationScoped.class)) {
            throw new WebBeansConfigurationException("Singleton Session Bean class : " + ejbBean.getReturnType() + " can not define scope other than @Dependent or @ApplicationScoped");
        }
    }

    public static void validateDecoratorOrInterceptor(Class<?> ejbClass) {
        Asserts.assertNotNull(ejbClass, (String)"ejbClass");
        if (AnnotationUtil.hasClassAnnotation(ejbClass, Decorator.class)) {
            throw new WebBeansConfigurationException("Ejb WebBeans Component with implementation class : " + ejbClass.getName() + " can not annotated with @Decorator");
        }
        if (AnnotationUtil.hasClassAnnotation(ejbClass, Interceptor.class)) {
            throw new WebBeansConfigurationException("Ejb WebBeans Component with implementation class : " + ejbClass.getName() + " can not annotated with @Interceptor");
        }
    }

    public static void validateGenericBeanType(Class<?> ejbClass, Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull(ejbClass, (String)"ejbClass");
        Asserts.assertNotNull(ejbClass, (String)"scopeType");
        if (ejbClass.getTypeParameters().length > 0 && !scopeType.equals(Dependent.class)) {
            throw new WebBeansConfigurationException("Ejb generic bean class : " + ejbClass.getName() + "scope must be @Dependent");
        }
    }

    public static <T> void validateObserverMethods(BaseEjbBean<?> bean, Set<ObserverMethod<T>> observers) {
        for (ObserverMethod<T> observer : observers) {
            ObserverMethodImpl obs = (ObserverMethodImpl)observer;
            AnnotatedMethod method = obs.getObserverMethod();
            List<Class<?>> locals = bean.getBusinessLocalInterfaces();
            if (locals == null) continue;
            Iterator<Class<?>> it = locals.iterator();
            boolean found = false;
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                Method classMethod = bean.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredMethod(clazz, method.getJavaMember().getName(), (Class[])method.getJavaMember().getParameterTypes());
                if (classMethod == null) continue;
                AnnotatedElementFactory annotatedElementFactory = bean.getWebBeansContext().getAnnotatedElementFactory();
                AnnotatedType declaringType = annotatedElementFactory.newAnnotatedType(classMethod.getDeclaringClass());
                obs.setObserverMethod(annotatedElementFactory.newAnnotatedMethod(classMethod, declaringType));
                found = true;
                break;
            }
            if (found || method.isStatic()) continue;
            throw new WebBeansConfigurationException("Observer method : " + method.getJavaMember().getName() + " in session bean class : " + bean.getBeanClass() + " must be business method");
        }
    }
}

