/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.metamodel.StaticMetamodel;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.GenericConfigurable;
import org.apache.openjpa.lib.meta.ClassAnnotationMetaDataFilter;
import org.apache.openjpa.lib.meta.ClassArgParser;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataParser;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.meta.AbstractCFMetaDataFactory;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataDefaults;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.persistence.AnnotationPersistenceMetaDataParser;
import org.apache.openjpa.persistence.AnnotationPersistenceMetaDataSerializer;
import org.apache.openjpa.persistence.AnnotationPersistenceXMLMetaDataParser;
import org.apache.openjpa.persistence.PersistenceMetaDataDefaults;
import org.apache.openjpa.persistence.XMLPersistenceMetaDataParser;
import org.apache.openjpa.persistence.XMLPersistenceMetaDataSerializer;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.MetaDataException;

public class PersistenceMetaDataFactory
extends AbstractCFMetaDataFactory
implements Configurable,
GenericConfigurable {
    private static final Localizer _loc = Localizer.forPackage(PersistenceMetaDataFactory.class);
    private final PersistenceMetaDataDefaults _def = new PersistenceMetaDataDefaults();
    private AnnotationPersistenceMetaDataParser _annoParser = null;
    private AnnotationPersistenceXMLMetaDataParser _annoXMLParser = null;
    private XMLPersistenceMetaDataParser _xmlParser = null;
    private Map<URL, Set<String>> _xml = null;
    private Set<URL> _unparsed = null;
    private boolean _fieldOverride = true;
    protected Stack<XMLPersistenceMetaDataParser> _stack = new Stack();
    private static String UNDERSCORE = "_";

    public void setFieldOverride(boolean field) {
        this._fieldOverride = field;
    }

    public boolean getFieldOverride() {
        return this._fieldOverride;
    }

    public AnnotationPersistenceMetaDataParser getAnnotationParser() {
        if (this._annoParser == null) {
            this._annoParser = this.newAnnotationParser();
            this._annoParser.setRepository(this.repos);
        }
        return this._annoParser;
    }

    public void setAnnotationParser(AnnotationPersistenceMetaDataParser parser) {
        if (this._annoParser != null) {
            this._annoParser.setRepository(null);
        }
        if (parser != null) {
            parser.setRepository(this.repos);
        }
        this._annoParser = parser;
    }

    protected AnnotationPersistenceMetaDataParser newAnnotationParser() {
        return new AnnotationPersistenceMetaDataParser(this.repos.getConfiguration());
    }

    protected AnnotationPersistenceMetaDataSerializer newAnnotationSerializer() {
        return new AnnotationPersistenceMetaDataSerializer(this.repos.getConfiguration());
    }

    public XMLPersistenceMetaDataParser getXMLParser() {
        if (this._xmlParser == null || this._xmlParser.isParsing()) {
            Class<?> parseCls = null;
            ArrayList<Class<?>> parseList = null;
            if (this._xmlParser != null) {
                this._stack.push(this._xmlParser);
                parseCls = this._xmlParser.getParseClass();
                parseList = this._xmlParser.getParseList();
            }
            this._xmlParser = this.newXMLParser(true);
            this._xmlParser.addToParseList(parseList);
            this._xmlParser.addToParseList(parseCls);
            this._xmlParser.setRepository(this.repos);
            if (this._fieldOverride) {
                this._xmlParser.setAnnotationParser(this.getAnnotationParser());
            }
        }
        return this._xmlParser;
    }

    public void resetXMLParser() {
        if (!this._stack.isEmpty()) {
            this._xmlParser.clear();
            this._xmlParser = this._stack.pop();
        }
    }

    public void setXMLParser(XMLPersistenceMetaDataParser parser) {
        if (this._xmlParser != null) {
            this._xmlParser.setRepository(null);
        }
        if (parser != null) {
            parser.setRepository(this.repos);
        }
        this._xmlParser = parser;
    }

    protected XMLPersistenceMetaDataParser newXMLParser(boolean loading) {
        return new XMLPersistenceMetaDataParser(this.repos.getConfiguration());
    }

    protected XMLPersistenceMetaDataSerializer newXMLSerializer() {
        return new XMLPersistenceMetaDataSerializer(this.repos.getConfiguration());
    }

    public void load(Class<?> cls, int mode, ClassLoader envLoader) {
        ClassMetaData meta;
        if (mode == 0) {
            return;
        }
        if (!this.strict && (mode & 1) != 0) {
            mode |= 2;
        }
        this.getPersistentTypeNames(false, envLoader);
        URL xml = this.findXML(cls);
        boolean parsedXML = false;
        if (this._unparsed != null && !this._unparsed.isEmpty() && (mode & 1) != 0) {
            HashSet<URL> unparsed = new HashSet<URL>(this._unparsed);
            for (URL url : unparsed) {
                this.parseXML(url, cls, mode, envLoader);
            }
            parsedXML = unparsed.contains(xml);
            this._unparsed.clear();
            meta = this.repos.getCachedMetaData(cls);
            if (meta != null && (meta.getSourceMode() & mode) == mode) {
                this.validateStrategies(meta);
                return;
            }
        }
        if (cls == null) {
            return;
        }
        if (!parsedXML && xml != null) {
            this.parseXML(xml, cls, mode, envLoader);
            meta = this.repos.getCachedMetaData(cls);
            if (meta != null && (meta.getSourceMode() & mode) == mode) {
                this.validateStrategies(meta);
                return;
            }
        }
        AnnotationPersistenceMetaDataParser parser = this.getAnnotationParser();
        parser.setEnvClassLoader(envLoader);
        parser.setMode(mode);
        parser.parse(cls);
        meta = this.repos.getCachedMetaData(cls);
        if (meta != null && (meta.getSourceMode() & mode) == mode) {
            this.validateStrategies(meta);
        }
    }

    private void parseXML(URL xml, Class<?> cls, int mode, ClassLoader envLoader) {
        ClassLoader loader = this.repos.getConfiguration().getClassResolverInstance().getClassLoader(cls, null);
        if (envLoader != null && envLoader != loader) {
            MultiClassLoader mult = new MultiClassLoader();
            mult.addClassLoader(envLoader);
            if (loader instanceof MultiClassLoader) {
                mult.addClassLoaders((MultiClassLoader)loader);
            } else {
                mult.addClassLoader(loader);
            }
            loader = mult;
        }
        XMLPersistenceMetaDataParser xmlParser = this.getXMLParser();
        xmlParser.setClassLoader(loader);
        xmlParser.setEnvClassLoader(envLoader);
        xmlParser.setMode(mode);
        try {
            xmlParser.parse(xml);
        }
        catch (IOException ioe) {
            throw new GeneralException((Throwable)ioe);
        }
        finally {
            this.resetXMLParser();
        }
    }

    private URL findXML(Class<?> cls) {
        if (this._xml != null && cls != null) {
            for (Map.Entry<URL, Set<String>> entry : this._xml.entrySet()) {
                if (!entry.getValue().contains(cls.getName())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    protected void mapPersistentTypeNames(Object rsrc, String[] names) {
        if (rsrc.toString().endsWith(".class")) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)_loc.get("map-persistent-types-skipping-class", rsrc));
            }
            return;
        }
        if (!(rsrc instanceof URL)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)_loc.get("map-persistent-types-skipping-non-url", rsrc));
            }
            return;
        }
        if (rsrc.toString().endsWith("/")) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)_loc.get("map-persistent-types-skipping-dir", rsrc));
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)_loc.get("map-persistent-type-names", rsrc, Arrays.asList(names)));
        }
        if (this._xml == null) {
            this._xml = new HashMap<URL, Set<String>>();
        }
        this._xml.put((URL)rsrc, new HashSet<String>(Arrays.asList(names)));
        if (this._unparsed == null) {
            this._unparsed = new HashSet<URL>();
        }
        this._unparsed.add((URL)rsrc);
    }

    public Class<?> getQueryScope(String queryName, ClassLoader loader) {
        if (queryName == null) {
            return null;
        }
        Collection classes = this.repos.loadPersistentTypes(false, loader);
        for (Class cls : classes) {
            if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)cls, NamedQuery.class))).booleanValue() && this.hasNamedQuery(queryName, cls.getAnnotation(NamedQuery.class))) {
                return cls;
            }
            if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)cls, NamedQueries.class))).booleanValue() && this.hasNamedQuery(queryName, cls.getAnnotation(NamedQueries.class).value())) {
                return cls;
            }
            if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)cls, NamedNativeQuery.class))).booleanValue() && this.hasNamedNativeQuery(queryName, cls.getAnnotation(NamedNativeQuery.class))) {
                return cls;
            }
            if (!((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)cls, NamedNativeQueries.class))).booleanValue() || !this.hasNamedNativeQuery(queryName, cls.getAnnotation(NamedNativeQueries.class).value())) continue;
            return cls;
        }
        return null;
    }

    public Class<?> getResultSetMappingScope(String rsMappingName, ClassLoader loader) {
        if (rsMappingName == null) {
            return null;
        }
        Collection classes = this.repos.loadPersistentTypes(false, loader);
        for (Class cls : classes) {
            if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)cls, SqlResultSetMapping.class))).booleanValue() && this.hasRSMapping(rsMappingName, cls.getAnnotation(SqlResultSetMapping.class))) {
                return cls;
            }
            if (!((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)cls, SqlResultSetMappings.class))).booleanValue() || !this.hasRSMapping(rsMappingName, cls.getAnnotation(SqlResultSetMappings.class).value())) continue;
            return cls;
        }
        return null;
    }

    private boolean hasNamedQuery(String query, NamedQuery ... queries) {
        for (NamedQuery q : queries) {
            if (!query.equals(q.name())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRSMapping(String rsMapping, SqlResultSetMapping ... mappings) {
        for (SqlResultSetMapping m : mappings) {
            if (!rsMapping.equals(m.name())) continue;
            return true;
        }
        return false;
    }

    private boolean hasNamedNativeQuery(String query, NamedNativeQuery ... queries) {
        for (NamedNativeQuery q : queries) {
            if (!query.equals(q.name())) continue;
            return true;
        }
        return false;
    }

    protected MetaDataFilter newMetaDataFilter() {
        ClassAnnotationMetaDataFilter camdf = new ClassAnnotationMetaDataFilter(new Class[]{Entity.class, Embeddable.class, MappedSuperclass.class});
        camdf.setLog(this.log);
        return camdf;
    }

    private void validateStrategies(ClassMetaData meta) {
        StringBuilder buf = null;
        for (FieldMetaData fmd : meta.getDeclaredFields()) {
            if (fmd.isExplicit()) continue;
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append(", ");
            }
            buf.append(fmd);
        }
        if (buf != null) {
            throw new MetaDataException(_loc.get("no-pers-strat", buf));
        }
    }

    public MetaDataDefaults getDefaults() {
        return this._def;
    }

    public ClassArgParser newClassArgParser() {
        ClassArgParser parser = new ClassArgParser();
        parser.setMetaDataStructure("package", null, new String[]{"entity", "embeddable", "mapped-superclass"}, "class");
        return parser;
    }

    public void clear() {
        super.clear();
        if (this._annoParser != null) {
            this._annoParser.clear();
        }
        if (this._xmlParser != null) {
            this._xmlParser.clear();
        }
        if (this._xml != null) {
            this._xml.clear();
        }
    }

    protected AbstractCFMetaDataFactory.Parser newParser(boolean loading) {
        return this.newXMLParser(loading);
    }

    protected AbstractCFMetaDataFactory.Serializer newSerializer() {
        return this.newXMLSerializer();
    }

    protected void parse(MetaDataParser parser, Class[] cls) {
        this.parse(parser, Collections.singleton(this.defaultXMLFile()));
    }

    protected File defaultSourceFile(ClassMetaData meta) {
        return this.defaultXMLFile();
    }

    protected File defaultSourceFile(QueryMetaData query, Map clsNames) {
        File file;
        ClassMetaData meta = this.getDefiningMetaData(query, clsNames);
        File file2 = file = meta == null ? null : meta.getSourceFile();
        if (file != null) {
            return file;
        }
        return this.defaultXMLFile();
    }

    protected File defaultSourceFile(SequenceMetaData seq, Map clsNames) {
        return this.defaultXMLFile();
    }

    private File defaultXMLFile() {
        File file;
        ClassLoader loader = this.repos.getConfiguration().getClassResolverInstance().getClassLoader(((Object)((Object)this)).getClass(), null);
        URL rsrc = (URL)AccessController.doPrivileged(J2DoPrivHelper.getResourceAction((ClassLoader)loader, (String)"META-INF/orm.xml"));
        if (rsrc != null && ((Boolean)AccessController.doPrivileged(J2DoPrivHelper.existsAction((File)(file = new File(rsrc.getFile()))))).booleanValue()) {
            return file;
        }
        return new File("orm.xml");
    }

    public void setConfiguration(Configuration conf) {
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
        if (this.rsrcs == null) {
            this.rsrcs = Collections.singleton("META-INF/orm.xml");
        } else {
            this.rsrcs.add("META-INF/orm.xml");
        }
    }

    public void setInto(Options opts) {
        opts.keySet().retainAll(opts.setInto((Object)this._def).keySet());
    }

    public AnnotationPersistenceXMLMetaDataParser getXMLAnnotationParser() {
        if (this._annoXMLParser == null) {
            this._annoXMLParser = this.newXMLAnnotationParser();
            this._annoXMLParser.setRepository(this.repos);
        }
        return this._annoXMLParser;
    }

    public void setXMLAnnotationParser(AnnotationPersistenceXMLMetaDataParser parser) {
        if (this._annoXMLParser != null) {
            this._annoXMLParser.setRepository(null);
        }
        if (parser != null) {
            parser.setRepository(this.repos);
        }
        this._annoXMLParser = parser;
    }

    protected AnnotationPersistenceXMLMetaDataParser newXMLAnnotationParser() {
        return new AnnotationPersistenceXMLMetaDataParser(this.repos.getConfiguration());
    }

    public void loadXMLMetaData(Class<?> cls) {
        AnnotationPersistenceXMLMetaDataParser parser = this.getXMLAnnotationParser();
        parser.parse(cls);
    }

    public String getManagedClassName(String mmClassName) {
        if (mmClassName == null || mmClassName.length() == 0) {
            return null;
        }
        if (mmClassName.endsWith(UNDERSCORE)) {
            return mmClassName.substring(0, mmClassName.length() - 1);
        }
        return mmClassName;
    }

    public String getMetaModelClassName(String managedClassName) {
        if (managedClassName == null || managedClassName.length() == 0) {
            return null;
        }
        return managedClassName + UNDERSCORE;
    }

    public boolean isMetaClass(Class<?> c) {
        return c != null && c.getAnnotation(StaticMetamodel.class) != null;
    }

    public Class<?> getManagedClass(Class<?> c) {
        if (this.isMetaClass(c)) {
            return c.getAnnotation(StaticMetamodel.class).value();
        }
        return null;
    }
}

