/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.MultiClassLoader;

public class ResourceMetaDataIterator
implements MetaDataIterator {
    private List _urls = null;
    private int _url = -1;

    public ResourceMetaDataIterator(String rsrc) throws IOException {
        this(rsrc, null);
    }

    public ResourceMetaDataIterator(String rsrc, ClassLoader loader) throws IOException {
        if (loader == null) {
            MultiClassLoader multi = (MultiClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
            multi.addClassLoader(MultiClassLoader.SYSTEM_LOADER);
            multi.addClassLoader(MultiClassLoader.THREAD_LOADER);
            multi.addClassLoader(this.getClass().getClassLoader());
            loader = multi;
        }
        try {
            Enumeration e = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction(loader, rsrc));
            while (e.hasMoreElements()) {
                if (this._urls == null) {
                    this._urls = new ArrayList(3);
                }
                this._urls.add(e.nextElement());
            }
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    public boolean hasNext() {
        return this._urls != null && this._url + 1 < this._urls.size();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._urls.get(++this._url);
    }

    public InputStream getInputStream() throws IOException {
        if (this._url == -1 || this._url >= this._urls.size()) {
            throw new IllegalStateException();
        }
        try {
            return (InputStream)AccessController.doPrivileged(J2DoPrivHelper.openStreamAction((URL)this._urls.get(this._url)));
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    public File getFile() throws IOException {
        if (this._url == -1 || this._url >= this._urls.size()) {
            throw new IllegalStateException();
        }
        File file = new File(URLDecoder.decode(((URL)this._urls.get(this._url)).getFile()));
        return (Boolean)AccessController.doPrivileged(J2DoPrivHelper.existsAction(file)) != false ? file : null;
    }

    public void close() {
    }
}

