/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.CellValueAdapter;

public class DefaultCellValueAdapter
implements CellValueAdapter {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_FORMAT = "'PT'HH'H'mm'M'ss'S'";
    private static final String DEFAULT_PERCENT_FORMAT = "0%";
    private static final String DEFAULT_CURRENCY_FORMAT = "$#,##0.00;-$#,##0.00";

    public void adaptValue(Cell cell, String value) {
        block48: {
            String type = cell.getValueType();
            String formatStr = cell.getFormatString();
            if ("boolean".equals(type)) {
                if ("true".equalsIgnoreCase(value)) {
                    cell.setBooleanValue(Boolean.TRUE);
                } else if ("false".equalsIgnoreCase(value)) {
                    cell.setBooleanValue(Boolean.FALSE);
                } else {
                    cell.setValueType("string");
                    this.adaptValue(cell, value);
                }
            } else if ("currency".equals(type)) {
                if (formatStr == null) {
                    formatStr = DEFAULT_CURRENCY_FORMAT;
                }
                try {
                    DecimalFormat decimalFormat = new DecimalFormat(formatStr);
                    Number number = decimalFormat.parse(value);
                    cell.setCurrencyValue(number.doubleValue(), cell.getCurrencyCode());
                    cell.setCurrencyFormat(cell.getCurrencySymbol(), formatStr);
                }
                catch (ParseException e) {
                    cell.setValueType("string");
                    this.adaptValue(cell, value);
                }
            } else if ("date".equals(type)) {
                if (formatStr == null) {
                    formatStr = DEFAULT_DATE_FORMAT;
                }
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatStr);
                    Date date = simpleDateFormat.parse(value);
                    Calendar calender = Calendar.getInstance();
                    calender.setTime(date);
                    cell.setDateValue(calender);
                }
                catch (ParseException e) {
                    cell.setValueType("string");
                    this.adaptValue(cell, value);
                }
            } else if ("float".equals(type)) {
                try {
                    if (formatStr != null) {
                        DecimalFormat decimalFormat = new DecimalFormat(formatStr);
                        Number number = decimalFormat.parse(value);
                        cell.setDoubleValue(number.doubleValue());
                        break block48;
                    }
                    Double doubleValue = Double.parseDouble(value);
                    cell.setDoubleValue(doubleValue);
                }
                catch (ParseException e) {
                    cell.setValueType("string");
                    this.adaptValue(cell, value);
                }
                catch (NumberFormatException e) {
                    cell.setValueType("string");
                    this.adaptValue(cell, value);
                }
            } else if ("percentage".equals(type)) {
                if (formatStr == null) {
                    formatStr = DEFAULT_PERCENT_FORMAT;
                }
                try {
                    DecimalFormat decimalFormat = new DecimalFormat(formatStr);
                    Number number = decimalFormat.parse(value);
                    cell.setPercentageValue(number.doubleValue());
                }
                catch (ParseException e) {
                    cell.setValueType("string");
                    this.adaptValue(cell, value);
                }
            } else if ("time".equals(type)) {
                if (formatStr == null) {
                    formatStr = DEFAULT_TIME_FORMAT;
                }
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatStr);
                    Date time = simpleDateFormat.parse(value);
                    Calendar calender = Calendar.getInstance();
                    calender.setTime(time);
                    cell.setTimeValue(calender);
                }
                catch (ParseException e) {
                    cell.setValueType("string");
                    this.adaptValue(cell, value);
                }
            } else if ("true".equalsIgnoreCase(value)) {
                cell.setBooleanValue(Boolean.TRUE);
            } else if ("false".equalsIgnoreCase(value)) {
                cell.setBooleanValue(Boolean.FALSE);
            } else {
                String[] floatFormats;
                String[] percentFormats;
                String[] timeFormats;
                String[] dateFormats;
                for (String dateFormat : dateFormats = new String[]{"MM/dd/yyyy", "MMM d, yyyy", DEFAULT_DATE_FORMAT, "MM/dd/yy"}) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                        Date date = simpleDateFormat.parse(value);
                        Calendar calender = Calendar.getInstance();
                        calender.setTime(date);
                        cell.setDateValue(calender);
                        cell.setFormatString(dateFormat);
                        return;
                    }
                    catch (ParseException e) {
                    }
                }
                for (String timeFormat : timeFormats = new String[]{"MM/dd/yyyy HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "HH:mm:ss", "HH:mm a", "HH:mm"}) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(timeFormat);
                        Date time = simpleDateFormat.parse(value);
                        Calendar calender = Calendar.getInstance();
                        calender.setTime(time);
                        cell.setTimeValue(calender);
                        cell.setFormatString(timeFormat);
                        return;
                    }
                    catch (ParseException e) {
                    }
                }
                for (String percentFormat : percentFormats = new String[]{"0.00%"}) {
                    try {
                        DecimalFormat decimalFormat = new DecimalFormat(percentFormat);
                        Number number = decimalFormat.parse(value);
                        cell.setPercentageValue(number.doubleValue());
                        cell.setFormatString(percentFormat);
                        return;
                    }
                    catch (ParseException e) {
                    }
                }
                for (String floatStr : floatFormats = new String[]{"#,##0"}) {
                    try {
                        DecimalFormat decimalFormat = new DecimalFormat(floatStr);
                        Number number = decimalFormat.parse(value);
                        cell.setDoubleValue(number.doubleValue());
                        cell.setFormatString(floatStr);
                        return;
                    }
                    catch (ParseException e) {
                    }
                }
                cell.setStringValue(value);
            }
        }
    }
}

