/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.krb.KerberosUser;

public class KerberosAction<T> {
    private final KerberosUser kerberosUser;
    private final PrivilegedExceptionAction<T> action;
    private final ComponentLog logger;

    public KerberosAction(KerberosUser kerberosUser, PrivilegedExceptionAction<T> action, ComponentLog logger) {
        this.kerberosUser = kerberosUser;
        this.action = action;
        this.logger = logger;
        Validate.notNull((Object)this.kerberosUser);
        Validate.notNull(this.action);
        Validate.notNull((Object)this.logger);
    }

    public T execute() {
        T result;
        if (!this.kerberosUser.isLoggedIn()) {
            try {
                this.kerberosUser.login();
                this.logger.info("Successful login for {}", new Object[]{this.kerberosUser.getPrincipal()});
            }
            catch (LoginException e) {
                throw new ProcessException("Login failed due to: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.kerberosUser.checkTGTAndRelogin();
        }
        catch (LoginException e) {
            throw new ProcessException("Relogin check failed due to: " + e.getMessage(), (Throwable)e);
        }
        try {
            result = this.kerberosUser.doAs(this.action);
        }
        catch (SecurityException se) {
            this.logger.info("Privileged action failed, attempting relogin and retrying...");
            this.logger.debug("", (Throwable)se);
            try {
                this.kerberosUser.logout();
                this.kerberosUser.login();
                result = this.kerberosUser.doAs(this.action);
            }
            catch (Exception e) {
                throw new ProcessException("Retrying privileged action failed due to: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (PrivilegedActionException e) {
            throw new ProcessException("Privileged action failed due to: " + e.getMessage(), (Throwable)e.getException());
        }
        return result;
    }
}

