/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

public class RecordFieldConverter {
    private final Record record;
    private final FlowFile flowFile;
    private final ComponentLog logger;

    public RecordFieldConverter(Record record, FlowFile flowFile, ComponentLog logger) {
        this.record = record;
        this.flowFile = flowFile;
        this.logger = logger;
    }

    public byte[] toBytes(String fieldName, RecordSetWriterFactory writerFactory) throws IOException {
        byte[] bytes;
        block7: {
            try {
                Object field = this.record.getValue(fieldName);
                if (field == null) {
                    bytes = null;
                    break block7;
                }
                if (field instanceof Record) {
                    bytes = this.toBytes((Record)field, writerFactory);
                    break block7;
                }
                if (field instanceof Byte[]) {
                    bytes = this.toBytes((Byte[])field);
                    break block7;
                }
                if (field instanceof Object[]) {
                    bytes = this.toBytes((Object[])field);
                    break block7;
                }
                if (field instanceof String) {
                    bytes = this.toBytes((String)field);
                    break block7;
                }
                throw new MalformedRecordException(String.format("Failed to convert [%s] record data to byte array", fieldName));
            }
            catch (SchemaNotFoundException | MalformedRecordException e) {
                throw new IOException("Field conversion failed", e);
            }
        }
        return bytes;
    }

    private byte[] toBytes(Record field, RecordSetWriterFactory writerFactory) throws MalformedRecordException, SchemaNotFoundException, IOException {
        if (writerFactory == null) {
            throw new MalformedRecordException("Record has a key that is itself a record, but the 'Record Key Writer' of the processor was not configured. If Records are expected to have a Record as the key, the 'Record Key Writer' property must be set.");
        }
        RecordSchema schema = writerFactory.getSchema(this.flowFile.getAttributes(), field.getSchema());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            block12: {
                RecordSetWriter writer = writerFactory.createWriter(this.logger, schema, (OutputStream)baos, this.flowFile);
                try {
                    writer.write(field);
                    writer.flush();
                    byArray = baos.toByteArray();
                    if (writer == null) break block12;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return byArray;
        }
    }

    private byte[] toBytes(Byte[] bytesSource) {
        byte[] bytesTarget = new byte[bytesSource.length];
        for (int i = 0; i < bytesSource.length; ++i) {
            bytesTarget[i] = bytesSource[i];
        }
        return bytesTarget;
    }

    private byte[] toBytes(Object[] objects) {
        byte[] bytesTarget = new byte[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            bytesTarget[i] = ((Integer)objects[i]).byteValue();
        }
        return bytesTarget;
    }

    private byte[] toBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }
}

