/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.key;

import java.io.IOException;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.kafka.processors.producer.key.KeyFactory;
import org.apache.nifi.kafka.processors.producer.wrapper.RecordFieldConverter;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.Record;

public class MessageKeyFactory
implements KeyFactory {
    private final FlowFile flowFile;
    private final String messageKeyField;
    private final RecordSetWriterFactory keyWriterFactory;
    private final ComponentLog logger;

    public MessageKeyFactory(FlowFile flowFile, String messageKeyField, RecordSetWriterFactory keyWriterFactory, ComponentLog logger) {
        this.flowFile = flowFile;
        this.messageKeyField = messageKeyField;
        this.keyWriterFactory = keyWriterFactory;
        this.logger = logger;
    }

    @Override
    public byte[] getKey(Map<String, String> attributes, Record record) throws IOException {
        RecordFieldConverter converter = new RecordFieldConverter(record, this.flowFile, this.logger);
        return converter.toBytes(this.messageKeyField, this.keyWriterFactory);
    }
}

