/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.key;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.kafka.processors.producer.key.KeyFactory;
import org.apache.nifi.serialization.record.Record;

public class AttributeKeyFactory
implements KeyFactory {
    private final String keyAttribute;
    private final String keyAttributeEncoding;

    public AttributeKeyFactory(String keyAttribute, String keyAttributeEncoding) {
        this.keyAttribute = keyAttribute;
        this.keyAttributeEncoding = Optional.ofNullable(keyAttributeEncoding).orElse(StandardCharsets.UTF_8.name());
    }

    @Override
    public byte[] getKey(Map<String, String> attributes, Record record) throws UnsupportedEncodingException {
        String keyAttributeValue = this.keyAttribute == null ? null : attributes.get(this.keyAttribute);
        return keyAttributeValue == null ? null : keyAttributeValue.getBytes(this.keyAttributeEncoding);
    }
}

