/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.header;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.processors.producer.header.HeadersFactory;
import org.apache.nifi.kafka.service.api.header.RecordHeader;

public class AttributesHeadersFactory
implements HeadersFactory {
    private final Pattern attributeNamePattern;
    private final Charset messageHeaderCharset;

    public AttributesHeadersFactory(Pattern attributeNamePattern, Charset messageHeaderCharset) {
        this.attributeNamePattern = attributeNamePattern;
        this.messageHeaderCharset = messageHeaderCharset;
    }

    @Override
    public List<RecordHeader> getHeaders(Map<String, String> attributes) {
        ArrayList<RecordHeader> headers = new ArrayList<RecordHeader>();
        if (this.attributeNamePattern != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (!this.attributeNamePattern.matcher(entry.getKey()).matches()) continue;
                headers.add(new RecordHeader(entry.getKey(), entry.getValue().getBytes(this.messageHeaderCharset)));
            }
        }
        return headers;
    }
}

