/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.convert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.nifi.kafka.processors.producer.common.ProducerUtils;
import org.apache.nifi.kafka.processors.producer.convert.KafkaRecordConverter;
import org.apache.nifi.kafka.processors.producer.header.HeadersFactory;
import org.apache.nifi.kafka.service.api.record.KafkaRecord;

public class FlowFileStreamKafkaRecordConverter
implements KafkaRecordConverter {
    final int maxMessageSize;
    final HeadersFactory headersFactory;

    public FlowFileStreamKafkaRecordConverter(int maxMessageSize, HeadersFactory headersFactory) {
        this.maxMessageSize = maxMessageSize;
        this.headersFactory = headersFactory;
    }

    @Override
    public Iterator<KafkaRecord> convert(Map<String, String> attributes, InputStream in, long inputLength) throws IOException {
        byte[] recordBytes;
        ProducerUtils.checkMessageSize(this.maxMessageSize, inputLength);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            in.transferTo(baos);
            recordBytes = baos.toByteArray();
        }
        KafkaRecord kafkaRecord = new KafkaRecord(null, null, null, null, recordBytes, this.headersFactory.getHeaders(attributes));
        return List.of(kafkaRecord).iterator();
    }
}

