/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.config;

import org.apache.nifi.components.DescribedValue;

public enum DeliveryGuarantee implements DescribedValue
{
    DELIVERY_REPLICATED("all", "Guarantee Replicated Delivery", "FlowFile will be routed to failure unless the message is replicated to the appropriate number of Kafka Nodes according to the Topic configuration"),
    DELIVERY_ONE_NODE("1", "Guarantee Single Node Delivery", "FlowFile will be routed to success if the message is received by a single Kafka node, whether or not it is replicated. This is faster than <Guarantee Replicated Delivery> but can result in data loss if a Kafka node crashes"),
    DELIVERY_BEST_EFFORT("0", "Best Effort", "FlowFile will be routed to success after successfully sending the content to a Kafka node, without waiting for any acknowledgment from the node at all. This provides the best performance but may result in data loss.");

    private final String value;
    private final String displayName;
    private final String description;

    private DeliveryGuarantee(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

