/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.FlowFileFilters;

public class PublishKafkaUtil {
    public static List<FlowFile> pollFlowFiles(ProcessSession session) {
        List initialFlowFiles = session.get(FlowFileFilters.newSizeBasedFilter((double)1.0, (DataUnit)DataUnit.MB, (int)500));
        if (initialFlowFiles.isEmpty()) {
            return initialFlowFiles;
        }
        boolean offsetsCommitted = true;
        for (FlowFile flowFile : initialFlowFiles) {
            if (!"false".equals(flowFile.getAttribute("kafka.consumer.offsets.committed"))) continue;
            offsetsCommitted = false;
            break;
        }
        if (offsetsCommitted) {
            return initialFlowFiles;
        }
        return PublishKafkaUtil.pollAllFlowFiles(session, initialFlowFiles);
    }

    private static List<FlowFile> pollAllFlowFiles(ProcessSession session, List<FlowFile> initialFlowFiles) {
        List flowFiles;
        ArrayList<FlowFile> polled = new ArrayList<FlowFile>(initialFlowFiles);
        while (!(flowFiles = session.get(10000)).isEmpty()) {
            polled.addAll(flowFiles);
        }
        return polled;
    }
}

