/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.producer;

import org.apache.nifi.components.DescribedValue;

public enum PartitionStrategy implements DescribedValue
{
    ROUND_ROBIN_PARTITIONING("org.apache.nifi.processors.kafka.pubsub.Partitioners.RoundRobinPartitioner", "RoundRobinPartitioner", "Messages will be assigned partitions in a round-robin fashion, sending the first message to Partition 1, the next Partition to Partition 2, and so on, wrapping as necessary."),
    RANDOM_PARTITIONING("org.apache.kafka.clients.producer.internals.DefaultPartitioner", "DefaultPartitioner", "The default partitioning strategy will choose the sticky partition that changes when the batch is full (See KIP-480 for details about sticky partitioning)."),
    EXPRESSION_LANGUAGE_PARTITIONING("org.apache.nifi.processors.kafka.pubsub.Partitioners.ExpressionLanguagePartitioner", "Expression Language Partitioner", "Interprets the <Partition> property as Expression Language that will be evaluated against each FlowFile. This Expression will be evaluated once against the FlowFile, so all Records in a given FlowFile will go to the same partition.");

    private final String value;
    private final String displayName;
    private final String description;

    private PartitionStrategy(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

