/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer.wrapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.kafka.processors.common.KafkaUtils;
import org.apache.nifi.kafka.shared.property.KeyEncoding;
import org.apache.nifi.kafka.shared.property.KeyFormat;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.Tuple;

public class WrapperRecordKeyReader {
    private final KeyFormat keyFormat;
    private final RecordReaderFactory keyReaderFactory;
    private final KeyEncoding keyEncoding;
    private final ComponentLog logger;
    private static final RecordField EMPTY_SCHEMA_KEY_RECORD_FIELD = new RecordField("key", RecordFieldType.RECORD.getRecordDataType((RecordSchema)new SimpleRecordSchema(Collections.emptyList())));

    public WrapperRecordKeyReader(KeyFormat keyFormat, RecordReaderFactory keyReaderFactory, KeyEncoding keyEncoding, ComponentLog logger) {
        this.keyReaderFactory = keyReaderFactory;
        this.keyFormat = keyFormat;
        this.keyEncoding = keyEncoding;
        this.logger = logger;
    }

    public Tuple<RecordField, Object> toWrapperRecordKey(byte[] key, Map<String, String> attributes) throws IOException, SchemaNotFoundException, MalformedRecordException {
        Tuple<RecordField, Object> wrapperRecordKey;
        if (KeyFormat.RECORD.equals((Object)this.keyFormat)) {
            wrapperRecordKey = this.toKeyRecord(key, attributes);
        } else if (KeyFormat.STRING.equals((Object)this.keyFormat)) {
            wrapperRecordKey = this.toKeyString(key);
        } else if (KeyFormat.BYTE_ARRAY.equals((Object)this.keyFormat)) {
            wrapperRecordKey = this.toKeyBytes(key);
        } else {
            throw new ProcessException(String.format("KeyFormat has an unknown value %s", this.keyFormat));
        }
        return wrapperRecordKey;
    }

    private Tuple<RecordField, Object> toKeyRecord(byte[] key, Map<String, String> attributes) throws IOException, SchemaNotFoundException, MalformedRecordException {
        Tuple keyRecord;
        if (key.length == 0) {
            keyRecord = new Tuple((Object)EMPTY_SCHEMA_KEY_RECORD_FIELD, null);
        } else {
            try (ByteArrayInputStream is = new ByteArrayInputStream(key);
                 RecordReader reader = this.keyReaderFactory.createRecordReader(attributes, (InputStream)is, (long)key.length, this.logger);){
                Record record = reader.nextRecord();
                RecordField recordField = new RecordField("key", RecordFieldType.RECORD.getRecordDataType(record.getSchema()));
                keyRecord = new Tuple((Object)recordField, (Object)record);
            }
        }
        return keyRecord;
    }

    private Tuple<RecordField, Object> toKeyString(byte[] key) {
        RecordField recordField = new RecordField("key", RecordFieldType.STRING.getDataType());
        return new Tuple((Object)recordField, (Object)KafkaUtils.toKeyString(key, this.keyEncoding));
    }

    private Tuple<RecordField, Object> toKeyBytes(byte[] key) {
        DataType dataType = RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.BYTE.getDataType());
        RecordField recordField = new RecordField("key", dataType);
        return new Tuple((Object)recordField, (Object)ArrayUtils.toObject((byte[])key));
    }
}

