/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer.wrapper;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.kafka.service.api.header.RecordHeader;
import org.apache.nifi.kafka.service.api.record.ByteRecord;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.Tuple;

public class ConsumeWrapperRecord {
    private static final RecordSchema EMPTY_SCHEMA = new SimpleRecordSchema(List.of());
    private final Charset headerCharacterSet;
    private static final RecordField FIELD_TOPIC = new RecordField("topic", RecordFieldType.STRING.getDataType());
    private static final RecordField FIELD_PARTITION = new RecordField("partition", RecordFieldType.INT.getDataType());
    private static final RecordField FIELD_OFFSET = new RecordField("offset", RecordFieldType.LONG.getDataType());
    private static final RecordField FIELD_TIMESTAMP = new RecordField("timestamp", RecordFieldType.TIMESTAMP.getDataType());
    private static final RecordSchema SCHEMA_WRAPPER = new SimpleRecordSchema(Arrays.asList(FIELD_TOPIC, FIELD_PARTITION, FIELD_OFFSET, FIELD_TIMESTAMP));

    public ConsumeWrapperRecord(Charset headerCharacterSet) {
        this.headerCharacterSet = headerCharacterSet;
    }

    public MapRecord toWrapperRecord(ByteRecord consumerRecord, Record record, Tuple<RecordField, Object> tupleKey) {
        Tuple<RecordField, Object> tupleValue = this.toWrapperRecordValue(record);
        Tuple<RecordField, Object> tupleHeaders = this.toWrapperRecordHeaders(consumerRecord);
        Tuple<RecordField, Object> tupleMetadata = this.toWrapperRecordMetadata(consumerRecord);
        SimpleRecordSchema rootRecordSchema = new SimpleRecordSchema(Arrays.asList((RecordField)tupleKey.getKey(), (RecordField)tupleValue.getKey(), (RecordField)tupleHeaders.getKey(), (RecordField)tupleMetadata.getKey()));
        HashMap<String, Object> recordValues = new HashMap<String, Object>();
        recordValues.put(((RecordField)tupleKey.getKey()).getFieldName(), tupleKey.getValue());
        recordValues.put(((RecordField)tupleValue.getKey()).getFieldName(), tupleValue.getValue());
        recordValues.put(((RecordField)tupleHeaders.getKey()).getFieldName(), tupleHeaders.getValue());
        recordValues.put(((RecordField)tupleMetadata.getKey()).getFieldName(), tupleMetadata.getValue());
        return new MapRecord((RecordSchema)rootRecordSchema, recordValues);
    }

    private Tuple<RecordField, Object> toWrapperRecordValue(Record record) {
        RecordSchema recordSchema = record == null ? EMPTY_SCHEMA : record.getSchema();
        RecordField recordField = new RecordField("value", RecordFieldType.RECORD.getRecordDataType(recordSchema));
        return new Tuple((Object)recordField, (Object)record);
    }

    private Tuple<RecordField, Object> toWrapperRecordHeaders(ByteRecord consumerRecord) {
        RecordField recordField = new RecordField("headers", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()));
        HashMap<String, String> headers = new HashMap<String, String>();
        for (RecordHeader header : consumerRecord.getHeaders()) {
            headers.put(header.key(), new String(header.value(), this.headerCharacterSet));
        }
        return new Tuple((Object)recordField, headers);
    }

    private Tuple<RecordField, Object> toWrapperRecordMetadata(ByteRecord consumerRecord) {
        RecordField recordField = new RecordField("metadata", RecordFieldType.RECORD.getRecordDataType(SCHEMA_WRAPPER));
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("topic", consumerRecord.getTopic());
        metadata.put("partition", consumerRecord.getPartition());
        metadata.put("offset", consumerRecord.getOffset());
        metadata.put("timestamp", consumerRecord.getTimestamp());
        MapRecord record = new MapRecord(SCHEMA_WRAPPER, metadata);
        return new Tuple((Object)recordField, (Object)record);
    }
}

