/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer.bundle;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.kafka.service.api.common.TopicPartitionSummary;
import org.apache.nifi.kafka.service.api.header.RecordHeader;

public class BundleKey {
    final TopicPartitionSummary topicPartition;
    final long timestamp;
    final List<RecordHeader> headers;
    final List<RecordHeader> headersFiltered;
    final Map<String, String> attributes;
    final byte[] messageKey;

    public BundleKey(TopicPartitionSummary topicPartition, long timestamp, List<RecordHeader> headers, List<RecordHeader> headersFiltered, Map<String, String> attributes, byte[] messageKey) {
        this.topicPartition = Objects.requireNonNull(topicPartition);
        this.timestamp = timestamp;
        this.headers = Objects.requireNonNull(headers);
        this.headersFiltered = Objects.requireNonNull(headersFiltered);
        this.attributes = attributes;
        this.messageKey = messageKey;
    }

    public TopicPartitionSummary getTopicPartition() {
        return this.topicPartition;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<RecordHeader> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public byte[] getMessageKey() {
        return this.messageKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleKey bundleKey = (BundleKey)o;
        return Objects.equals(this.topicPartition, bundleKey.topicPartition) && Objects.equals(this.headersFiltered, bundleKey.headersFiltered) && Arrays.equals(this.messageKey, bundleKey.messageKey);
    }

    public int hashCode() {
        return Objects.hash(this.topicPartition, this.headersFiltered, Arrays.hashCode(this.messageKey));
    }
}

