/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors.consumer;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.service.api.common.OffsetSummary;
import org.apache.nifi.kafka.service.api.common.TopicPartitionSummary;
import org.apache.nifi.kafka.service.api.consumer.PollingContext;
import org.apache.nifi.kafka.service.api.consumer.PollingSummary;
import org.apache.nifi.kafka.service.api.record.ByteRecord;

public class OffsetTracker {
    private final Map<TopicPartitionSummary, OffsetSummary> offsets = new LinkedHashMap<TopicPartitionSummary, OffsetSummary>();

    public void update(ByteRecord consumerRecord) {
        TopicPartitionSummary topicPartitionSummary = new TopicPartitionSummary(consumerRecord.getTopic(), consumerRecord.getPartition());
        long offset = consumerRecord.getOffset();
        OffsetSummary offsetSummary = this.offsets.computeIfAbsent(topicPartitionSummary, summary -> new OffsetSummary(offset));
        offsetSummary.setOffset(offset);
    }

    public PollingSummary getPollingSummary(PollingContext pollingContext) {
        PollingSummary pollingSummary = pollingContext.getTopicPattern().isPresent() ? new PollingSummary(pollingContext.getGroupId(), (Pattern)pollingContext.getTopicPattern().get(), pollingContext.getAutoOffsetReset(), pollingContext.getMaxUncommittedTime(), this.offsets) : new PollingSummary(pollingContext.getGroupId(), pollingContext.getTopics(), pollingContext.getAutoOffsetReset(), pollingContext.getMaxUncommittedTime(), this.offsets);
        return pollingSummary;
    }
}

