/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.processors;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kafka.processors.PublishKafka;
import org.apache.nifi.kafka.processors.common.KafkaUtils;
import org.apache.nifi.kafka.processors.consumer.OffsetTracker;
import org.apache.nifi.kafka.processors.consumer.ProcessingStrategy;
import org.apache.nifi.kafka.processors.consumer.bundle.ByteRecordBundler;
import org.apache.nifi.kafka.processors.consumer.convert.FlowFileStreamKafkaMessageConverter;
import org.apache.nifi.kafka.processors.consumer.convert.KafkaMessageConverter;
import org.apache.nifi.kafka.processors.consumer.convert.RecordStreamKafkaMessageConverter;
import org.apache.nifi.kafka.processors.consumer.convert.WrapperRecordStreamKafkaMessageConverter;
import org.apache.nifi.kafka.service.api.KafkaConnectionService;
import org.apache.nifi.kafka.service.api.consumer.AutoOffsetReset;
import org.apache.nifi.kafka.service.api.consumer.KafkaConsumerService;
import org.apache.nifi.kafka.service.api.consumer.PollingContext;
import org.apache.nifi.kafka.service.api.record.ByteRecord;
import org.apache.nifi.kafka.shared.property.KeyEncoding;
import org.apache.nifi.kafka.shared.property.KeyFormat;
import org.apache.nifi.kafka.shared.property.OutputStrategy;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.util.StringUtils;

@CapabilityDescription(value="Consumes messages from Apache Kafka Consumer API. The complementary NiFi processor for sending messages is PublishKafka. The Processor supports consumption of Kafka messages, optionally interpreted as NiFi records. Please note that, at this time (in read record mode), the Processor assumes that all records that are retrieved from a given partition have the same schema. For this mode, if any of the Kafka messages are pulled but cannot be parsed or written with the configured Record Reader or Record Writer, the contents of the message will be written to a separate FlowFile, and that FlowFile will be transferred to the 'parse.failure' relationship. Otherwise, each FlowFile is sent to the 'success' relationship and may contain many individual messages within the single FlowFile. A 'record.count' attribute is added to indicate how many messages are contained in the FlowFile. No two Kafka messages will be placed into the same FlowFile if they have different schemas, or if they have different values for a message header that is included by the <Headers to Add as Attributes> property.")
@Tags(value={"Kafka", "Get", "Record", "csv", "avro", "json", "Ingest", "Ingress", "Topic", "PubSub", "Consume"})
@WritesAttributes(value={@WritesAttribute(attribute="record.count", description="The number of records received"), @WritesAttribute(attribute="mime.type", description="The MIME Type that is provided by the configured Record Writer"), @WritesAttribute(attribute="kafka.count", description="The number of messages written if more than one"), @WritesAttribute(attribute="kafka.key", description="The key of message if present and if single message. How the key is encoded depends on the value of the 'Key Attribute Encoding' property."), @WritesAttribute(attribute="kafka.offset", description="The offset of the message in the partition of the topic."), @WritesAttribute(attribute="kafka.timestamp", description="The timestamp of the message in the partition of the topic."), @WritesAttribute(attribute="kafka.partition", description="The partition of the topic the message or message bundle is from"), @WritesAttribute(attribute="kafka.topic", description="The topic the message or message bundle is from"), @WritesAttribute(attribute="kafka.tombstone", description="Set to true if the consumed message is a tombstone message")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@SeeAlso(value={PublishKafka.class})
public class ConsumeKafka
extends AbstractProcessor
implements VerifiableProcessor {
    static final AllowableValue TOPIC_NAME = new AllowableValue("names", "names", "Topic is a full topic name or comma separated list of names");
    static final AllowableValue TOPIC_PATTERN = new AllowableValue("pattern", "pattern", "Topic is a regular expression according to the Java Pattern syntax");
    static final PropertyDescriptor CONNECTION_SERVICE = new PropertyDescriptor.Builder().name("Kafka Connection Service").description("Provides connections to Kafka Broker for publishing Kafka Records").identifiesControllerService(KafkaConnectionService.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).build();
    static final PropertyDescriptor GROUP_ID = new PropertyDescriptor.Builder().name("Group ID").description("Kafka Consumer Group Identifier corresponding to Kafka group.id property").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor TOPIC_FORMAT = new PropertyDescriptor.Builder().name("Topic Format").description("Specifies whether the Topics provided are a comma separated list of names or a single regular expression").required(true).allowableValues(new DescribedValue[]{TOPIC_NAME, TOPIC_PATTERN}).defaultValue((DescribedValue)TOPIC_NAME).build();
    static final PropertyDescriptor TOPICS = new PropertyDescriptor.Builder().name("Topics").description("The name or pattern of the Kafka Topics from which the Processor consumes Kafka Records. More than one can be supplied if comma separated.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor AUTO_OFFSET_RESET = new PropertyDescriptor.Builder().name("auto.offset.reset").displayName("Auto Offset Reset").description("Automatic offset configuration applied when no previous consumer offset found corresponding to Kafka auto.offset.reset property").required(true).allowableValues(AutoOffsetReset.class).defaultValue(AutoOffsetReset.LATEST.getValue()).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor COMMIT_OFFSETS = new PropertyDescriptor.Builder().name("Commit Offsets").description("Specifies whether this Processor should commit the offsets to Kafka after receiving messages. Typically, this value should be set to true so that messages that are received are not duplicated. However, in certain scenarios, we may want to avoid committing the offsets, that the data can be processed and later acknowledged by PublishKafka in order to provide Exactly Once semantics.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    static final PropertyDescriptor MAX_UNCOMMITTED_TIME = new PropertyDescriptor.Builder().name("Max Uncommitted Time").description("Specifies the maximum amount of time allowed to pass before offsets must be committed. This value impacts how often offsets will be committed. Committing offsets less often increases throughput but also increases the window of potential data duplication in the event of a rebalance or JVM restart between commits. This value is also related to maximum poll records and the use of a message demarcator. When using a message demarcator we can have far more uncommitted messages than when we're not as there is much less for us to keep track of in memory.").required(true).defaultValue("1 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).dependsOn(COMMIT_OFFSETS, "true", new String[0]).build();
    static final PropertyDescriptor HEADER_ENCODING = new PropertyDescriptor.Builder().name("Header Encoding").description("Character encoding applied when reading Kafka Record Header values and writing FlowFile attributes").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue(StandardCharsets.UTF_8.name()).required(true).build();
    static final PropertyDescriptor HEADER_NAME_PATTERN = new PropertyDescriptor.Builder().name("Header Name Pattern").description("Regular Expression Pattern applied to Kafka Record Header Names for selecting Header Values to be written as FlowFile attributes").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).required(false).build();
    static final PropertyDescriptor PROCESSING_STRATEGY = new PropertyDescriptor.Builder().name("Processing Strategy").description("Strategy for processing Kafka Records and writing serialized output to FlowFiles").required(true).allowableValues(ProcessingStrategy.class).defaultValue(ProcessingStrategy.FLOW_FILE.getValue()).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("Record Reader").description("The Record Reader to use for incoming Kafka messages").identifiesControllerService(RecordReaderFactory.class).required(true).dependsOn(PROCESSING_STRATEGY, (DescribedValue)ProcessingStrategy.RECORD, new DescribedValue[0]).build();
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("Record Writer").description("The Record Writer to use in order to serialize the outgoing FlowFiles").identifiesControllerService(RecordSetWriterFactory.class).required(true).dependsOn(PROCESSING_STRATEGY, (DescribedValue)ProcessingStrategy.RECORD, new DescribedValue[0]).build();
    static final PropertyDescriptor OUTPUT_STRATEGY = new PropertyDescriptor.Builder().name("Output Strategy").description("The format used to output the Kafka Record into a FlowFile Record.").required(true).defaultValue((DescribedValue)OutputStrategy.USE_VALUE).allowableValues(OutputStrategy.class).dependsOn(PROCESSING_STRATEGY, (DescribedValue)ProcessingStrategy.RECORD, new DescribedValue[0]).build();
    static final PropertyDescriptor KEY_ATTRIBUTE_ENCODING = new PropertyDescriptor.Builder().name("Key Attribute Encoding").description("Encoding for value of configured FlowFile attribute containing Kafka Record Key.").required(true).defaultValue((DescribedValue)KeyEncoding.UTF8).allowableValues(KeyEncoding.class).dependsOn(OUTPUT_STRATEGY, (DescribedValue)OutputStrategy.USE_VALUE, new DescribedValue[0]).build();
    static final PropertyDescriptor KEY_FORMAT = new PropertyDescriptor.Builder().name("Key Format").description("Specifies how to represent the Kafka Record Key in the output FlowFile").required(true).defaultValue((DescribedValue)KeyFormat.BYTE_ARRAY).allowableValues(KeyFormat.class).dependsOn(OUTPUT_STRATEGY, (DescribedValue)OutputStrategy.USE_WRAPPER, new DescribedValue[0]).build();
    static final PropertyDescriptor KEY_RECORD_READER = new PropertyDescriptor.Builder().name("Key Record Reader").description("The Record Reader to use for parsing the Kafka Record Key into a Record").identifiesControllerService(RecordReaderFactory.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).dependsOn(KEY_FORMAT, (DescribedValue)KeyFormat.RECORD, new DescribedValue[0]).build();
    static final PropertyDescriptor MESSAGE_DEMARCATOR = new PropertyDescriptor.Builder().name("Message Demarcator").required(true).addValidator(Validator.VALID).description("Since KafkaConsumer receives messages in batches, this Processor has an option to output FlowFiles which contains all Kafka messages in a single batch for a given topic and partition and this property allows you to provide a string (interpreted as UTF-8) to use for demarcating apart multiple Kafka messages. This is an optional property and if not provided each Kafka message received will result in a single FlowFile which  time it is triggered. To enter special character such as 'new line' use CTRL+Enter or Shift+Enter depending on the OS").dependsOn(PROCESSING_STRATEGY, (DescribedValue)ProcessingStrategy.DEMARCATOR, new DescribedValue[0]).build();
    static final PropertyDescriptor SEPARATE_BY_KEY = new PropertyDescriptor.Builder().name("Separate By Key").description("When this property is enabled, two messages will only be added to the same FlowFile if both of the Kafka Messages have identical keys.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").dependsOn(MESSAGE_DEMARCATOR, new AllowableValue[0]).build();
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").description("FlowFiles containing one or more serialized Kafka Records").build();
    public static final Relationship PARSE_FAILURE = new Relationship.Builder().name("parse failure").description("If configured to use a Record Reader, a Kafka message that cannot be parsed using the configured Record Reader will be routed to this relationship").build();
    private static final List<PropertyDescriptor> DESCRIPTORS = List.of(CONNECTION_SERVICE, GROUP_ID, TOPIC_FORMAT, TOPICS, AUTO_OFFSET_RESET, COMMIT_OFFSETS, MAX_UNCOMMITTED_TIME, HEADER_NAME_PATTERN, HEADER_ENCODING, PROCESSING_STRATEGY, RECORD_READER, RECORD_WRITER, OUTPUT_STRATEGY, KEY_ATTRIBUTE_ENCODING, KEY_FORMAT, KEY_RECORD_READER, MESSAGE_DEMARCATOR, SEPARATE_BY_KEY);
    private static final Set<Relationship> SUCCESS_RELATIONSHIP = Set.of(SUCCESS);
    private static final Set<Relationship> SUCCESS_FAILURE_RELATIONSHIPS = Set.of(SUCCESS, PARSE_FAILURE);
    private volatile Charset headerEncoding;
    private volatile Pattern headerNamePattern;
    private volatile KeyEncoding keyEncoding;
    private volatile OutputStrategy outputStrategy;
    private volatile KeyFormat keyFormat;
    private volatile boolean commitOffsets;
    private volatile boolean useReader;
    private volatile PollingContext pollingContext;
    private final Queue<KafkaConsumerService> consumerServices = new LinkedBlockingQueue<KafkaConsumerService>();

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return this.useReader ? SUCCESS_FAILURE_RELATIONSHIPS : SUCCESS_RELATIONSHIP;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)RECORD_READER)) {
            this.useReader = newValue != null;
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        KafkaConnectionService connectionService = (KafkaConnectionService)context.getProperty(CONNECTION_SERVICE).asControllerService(KafkaConnectionService.class);
        this.pollingContext = this.createPollingContext(context);
        this.headerEncoding = Charset.forName(context.getProperty(HEADER_ENCODING).getValue());
        String headerNamePatternProperty = context.getProperty(HEADER_NAME_PATTERN).getValue();
        this.headerNamePattern = StringUtils.isNotBlank((String)headerNamePatternProperty) ? Pattern.compile(headerNamePatternProperty) : null;
        this.keyEncoding = (KeyEncoding)context.getProperty(KEY_ATTRIBUTE_ENCODING).asAllowableValue(KeyEncoding.class);
        this.commitOffsets = context.getProperty(COMMIT_OFFSETS).asBoolean();
        this.outputStrategy = (OutputStrategy)context.getProperty(OUTPUT_STRATEGY).asAllowableValue(OutputStrategy.class);
        this.keyFormat = (KeyFormat)context.getProperty(KEY_FORMAT).asAllowableValue(KeyFormat.class);
    }

    @OnStopped
    public void onStopped() {
        KafkaConsumerService service;
        while ((service = this.consumerServices.poll()) != null) {
            try {
                service.close();
            }
            catch (IOException e) {
                this.getLogger().warn("Failed to close Kafka Consumer Service", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) {
        KafkaConsumerService consumerService = this.getConsumerService(context);
        try {
            Iterator<ByteRecord> consumerRecords = consumerService.poll().iterator();
            if (!consumerRecords.hasNext()) {
                this.getLogger().debug("No Kafka Records consumed: {}", new Object[]{this.pollingContext});
                return;
            }
            this.processConsumerRecords(context, session, consumerService, this.pollingContext, consumerRecords);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to consume Kafka Records", (Throwable)e);
            consumerService.rollback();
            try {
                consumerService.close();
            }
            catch (IOException ex) {
                this.getLogger().warn("Failed to close Kafka Consumer Service", (Throwable)ex);
            }
        }
        finally {
            if (!consumerService.isClosed()) {
                this.consumerServices.offer(consumerService);
            }
        }
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> verificationResults = new ArrayList<ConfigVerificationResult>();
        KafkaConnectionService connectionService = (KafkaConnectionService)context.getProperty(CONNECTION_SERVICE).asControllerService(KafkaConnectionService.class);
        PollingContext pollingContext = this.createPollingContext(context);
        KafkaConsumerService consumerService = connectionService.getConsumerService(pollingContext);
        ConfigVerificationResult.Builder verificationPartitions = new ConfigVerificationResult.Builder().verificationStepName("Verify Topic Partitions");
        try {
            List partitionStates = consumerService.getPartitionStates();
            verificationPartitions.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Partitions [%d] found for Topics %s", partitionStates.size(), pollingContext.getTopics()));
        }
        catch (Exception e) {
            this.getLogger().error("Topics {} Partition verification failed", new Object[]{pollingContext.getTopics(), e});
            verificationPartitions.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Topics %s Partition access failed: %s", pollingContext.getTopics(), e));
        }
        verificationResults.add(verificationPartitions.build());
        return verificationResults;
    }

    private KafkaConsumerService getConsumerService(ProcessContext context) {
        KafkaConsumerService consumerService = this.consumerServices.poll();
        if (consumerService != null) {
            return consumerService;
        }
        KafkaConnectionService connectionService = (KafkaConnectionService)context.getProperty(CONNECTION_SERVICE).asControllerService(KafkaConnectionService.class);
        return connectionService.getConsumerService(this.pollingContext);
    }

    private void processConsumerRecords(ProcessContext context, ProcessSession session, KafkaConsumerService consumerService, PollingContext pollingContext, Iterator<ByteRecord> consumerRecords) {
        ProcessingStrategy processingStrategy = ProcessingStrategy.valueOf(context.getProperty(PROCESSING_STRATEGY).getValue());
        switch (processingStrategy) {
            case RECORD: {
                this.processInputRecords(context, session, consumerService, pollingContext, consumerRecords);
                break;
            }
            case FLOW_FILE: {
                this.processInputFlowFile(session, consumerService, pollingContext, consumerRecords);
                break;
            }
            case DEMARCATOR: {
                Iterator<ByteRecord> demarcatedRecords = this.transformDemarcator(context, consumerRecords);
                this.processInputFlowFile(session, consumerService, pollingContext, demarcatedRecords);
            }
        }
    }

    private Iterator<ByteRecord> transformDemarcator(ProcessContext context, Iterator<ByteRecord> consumerRecords) {
        String demarcatorValue = context.getProperty(MESSAGE_DEMARCATOR).getValue();
        if (demarcatorValue == null) {
            return consumerRecords;
        }
        byte[] demarcator = demarcatorValue.getBytes(StandardCharsets.UTF_8);
        boolean separateByKey = context.getProperty(SEPARATE_BY_KEY).asBoolean();
        return new ByteRecordBundler(demarcator, separateByKey, this.keyEncoding, this.headerNamePattern, this.headerEncoding, this.commitOffsets).bundle(consumerRecords);
    }

    private void processInputRecords(ProcessContext context, ProcessSession session, KafkaConsumerService consumerService, PollingContext pollingContext, Iterator<ByteRecord> consumerRecords) {
        KafkaMessageConverter converter;
        Runnable onSuccess;
        RecordReaderFactory readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        OffsetTracker offsetTracker = new OffsetTracker();
        Runnable runnable = onSuccess = this.commitOffsets ? () -> session.commitAsync(() -> consumerService.commit(offsetTracker.getPollingSummary(pollingContext))) : () -> ((ProcessSession)session).commitAsync();
        if (OutputStrategy.USE_VALUE.equals((Object)this.outputStrategy)) {
            converter = new RecordStreamKafkaMessageConverter(readerFactory, writerFactory, this.headerEncoding, this.headerNamePattern, this.keyEncoding, this.commitOffsets, offsetTracker, onSuccess, this.getLogger());
        } else if (OutputStrategy.USE_WRAPPER.equals((Object)this.outputStrategy)) {
            RecordReaderFactory keyReaderFactory = (RecordReaderFactory)context.getProperty(KEY_RECORD_READER).asControllerService(RecordReaderFactory.class);
            converter = new WrapperRecordStreamKafkaMessageConverter(readerFactory, writerFactory, keyReaderFactory, this.headerEncoding, this.headerNamePattern, this.keyFormat, this.keyEncoding, this.commitOffsets, offsetTracker, onSuccess, this.getLogger());
        } else {
            throw new ProcessException(String.format("Output Strategy not supported [%s]", this.outputStrategy));
        }
        converter.toFlowFiles(session, consumerRecords);
    }

    private void processInputFlowFile(ProcessSession session, KafkaConsumerService consumerService, PollingContext pollingContext, Iterator<ByteRecord> consumerRecords) {
        OffsetTracker offsetTracker = new OffsetTracker();
        Runnable onSuccess = this.commitOffsets ? () -> session.commitAsync(() -> consumerService.commit(offsetTracker.getPollingSummary(pollingContext))) : () -> ((ProcessSession)session).commitAsync();
        FlowFileStreamKafkaMessageConverter converter = new FlowFileStreamKafkaMessageConverter(this.headerEncoding, this.headerNamePattern, this.keyEncoding, this.commitOffsets, offsetTracker, onSuccess);
        converter.toFlowFiles(session, consumerRecords);
    }

    private PollingContext createPollingContext(ProcessContext context) {
        PollingContext pollingContext;
        String groupId = context.getProperty(GROUP_ID).getValue();
        String offsetReset = context.getProperty(AUTO_OFFSET_RESET).getValue();
        AutoOffsetReset autoOffsetReset = AutoOffsetReset.valueOf((String)offsetReset.toUpperCase());
        String topics = context.getProperty(TOPICS).evaluateAttributeExpressions().getValue();
        String topicFormat = context.getProperty(TOPIC_FORMAT).getValue();
        Duration maxUncommittedTime = context.getProperty(MAX_UNCOMMITTED_TIME).asDuration();
        if (topicFormat.equals(TOPIC_PATTERN.getValue())) {
            Pattern topicPattern = Pattern.compile(topics.trim());
            pollingContext = new PollingContext(groupId, topicPattern, autoOffsetReset, maxUncommittedTime);
        } else if (topicFormat.equals(TOPIC_NAME.getValue())) {
            Collection<String> topicList = KafkaUtils.toTopicList(topics);
            pollingContext = new PollingContext(groupId, topicList, autoOffsetReset, maxUncommittedTime);
        } else {
            throw new ProcessException(String.format("Topic Format [%s] not supported", topicFormat));
        }
        return pollingContext;
    }
}

