/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.github;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Base64;
import java.util.Objects;
import org.apache.nifi.github.PrivateKeyReader;

class StandardPrivateKeyReader
implements PrivateKeyReader {
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final String RSA_ALGORITHM = "RSA";
    private static final String PKCS1_FORMAT = "PKCS#1";
    private static final String PEM_BOUNDARY_PREFIX = "-----";

    StandardPrivateKeyReader() {
    }

    @Override
    public PrivateKey readPrivateKey(String inputPrivateKey) throws GeneralSecurityException {
        Objects.requireNonNull(inputPrivateKey, "Private Key required");
        byte[] decoded = this.getDecoded(inputPrivateKey);
        PKCS1EncodedPrivateKey encodedPrivateKey = new PKCS1EncodedPrivateKey(decoded);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        Key translatedKey = keyFactory.translateKey(encodedPrivateKey);
        if (translatedKey instanceof RSAPrivateKey) {
            return (RSAPrivateKey)translatedKey;
        }
        throw new InvalidKeyException("Failed to parse encoded RSA Private Key: unsupported class [%s]".formatted(translatedKey.getClass()));
    }

    private byte[] getDecoded(String inputPrivateKey) throws GeneralSecurityException {
        byte[] byArray;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(inputPrivateKey));
        try {
            StringBuilder encodedBuilder = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null) {
                if (!line.startsWith(PEM_BOUNDARY_PREFIX)) {
                    encodedBuilder.append(line);
                }
                line = bufferedReader.readLine();
            }
            String encoded = encodedBuilder.toString();
            byArray = DECODER.decode(encoded);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidKeyException("Failed to read Private Key", e);
            }
        }
        bufferedReader.close();
        return byArray;
    }

    private static class PKCS1EncodedPrivateKey
    implements PrivateKey {
        private final byte[] encoded;

        private PKCS1EncodedPrivateKey(byte[] encoded) {
            this.encoded = encoded;
        }

        @Override
        public String getAlgorithm() {
            return StandardPrivateKeyReader.RSA_ALGORITHM;
        }

        @Override
        public String getFormat() {
            return StandardPrivateKeyReader.PKCS1_FORMAT;
        }

        @Override
        public byte[] getEncoded() {
            return (byte[])this.encoded.clone();
        }
    }
}

