/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.jsch;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.ScpHelper;
import org.apache.maven.wagon.providers.ssh.jsch.AbstractJschWagon;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpWagon
extends AbstractJschWagon {
    private static final String SFTP_CHANNEL = "sftp";
    private static final int S_IFDIR = 16384;
    private static final long MILLIS_PER_SEC = 1000L;
    private ChannelSftp channel;

    @Override
    public void closeConnection() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        super.closeConnection();
    }

    @Override
    public void openConnectionInternal() throws AuthenticationException {
        super.openConnectionInternal();
        try {
            this.channel = (ChannelSftp)this.session.openChannel(SFTP_CHANNEL);
            this.channel.connect();
        }
        catch (JSchException e) {
            throw new AuthenticationException("Error connecting to remote repository: " + this.getRepository().getUrl(), (Throwable)e);
        }
    }

    private void returnToParentDirectory(Resource resource) {
        try {
            String dir = ScpHelper.getResourceDirectory((String)resource.getName());
            String[] dirs = PathUtils.dirnames((String)dir);
            for (int i = 0; i < dirs.length; ++i) {
                this.channel.cd("..");
            }
        }
        catch (SftpException e) {
            this.fireTransferDebug("Error returning to parent directory: " + e.getMessage());
        }
    }

    private void putFile(File source, Resource resource, RepositoryPermissions permissions) throws SftpException, TransferFailedException {
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        String filename = ScpHelper.getResourceFilename((String)resource.getName());
        this.firePutStarted(resource, source);
        this.channel.put(source.getAbsolutePath(), filename);
        this.postProcessListeners(resource, source, 6);
        if (permissions != null && permissions.getGroup() != null) {
            this.setGroup(filename, permissions);
        }
        if (permissions != null && permissions.getFileMode() != null) {
            this.setFileMode(filename, permissions);
        }
        this.firePutCompleted(resource, source);
    }

    private void setGroup(String filename, RepositoryPermissions permissions) {
        try {
            int group = Integer.valueOf(permissions.getGroup());
            this.channel.chgrp(group, filename);
        }
        catch (NumberFormatException e) {
            this.fireTransferDebug("Not setting group: must be a numerical GID for SFTP");
        }
        catch (SftpException e) {
            this.fireTransferDebug("Not setting group: " + e.getMessage());
        }
    }

    private void setFileMode(String filename, RepositoryPermissions permissions) {
        try {
            int mode = this.getOctalMode(permissions.getFileMode());
            this.channel.chmod(mode, filename);
        }
        catch (NumberFormatException e) {
            this.fireTransferDebug("Not setting mode: must be a numerical mode for SFTP");
        }
        catch (SftpException e) {
            this.fireTransferDebug("Not setting mode: " + e.getMessage());
        }
    }

    private void mkdirs(String resourceName, int mode) throws SftpException, TransferFailedException {
        String[] dirs;
        for (String dir : dirs = PathUtils.dirnames((String)resourceName)) {
            this.mkdir(dir, mode);
            this.channel.cd(dir);
        }
    }

    private void mkdir(String dir, int mode) throws TransferFailedException, SftpException {
        block5: {
            try {
                SftpATTRS attrs = this.channel.stat(dir);
                if ((attrs.getPermissions() & 0x4000) == 0) {
                    throw new TransferFailedException("Remote path is not a directory: " + dir);
                }
            }
            catch (SftpException e) {
                this.channel.mkdir(dir);
                if (mode == -1) break block5;
                try {
                    this.channel.chmod(mode, dir);
                }
                catch (SftpException e1) {
                    // empty catch block
                }
            }
        }
    }

    private SftpATTRS changeToRepositoryDirectory(String dir, String filename) throws ResourceDoesNotExistException, SftpException {
        SftpATTRS attrs;
        try {
            this.channel.cd(this.repository.getBasedir());
            if (dir.length() > 0) {
                this.channel.cd(dir);
            }
            if (filename.length() == 0) {
                filename = ".";
            }
            attrs = this.channel.stat(filename);
        }
        catch (SftpException e) {
            if (e.toString().trim().endsWith("No such file")) {
                throw new ResourceDoesNotExistException(e.toString(), (Throwable)e);
            }
            if (e.toString().trim().indexOf("Can't change directory") != -1) {
                throw new ResourceDoesNotExistException(e.toString(), (Throwable)e);
            }
            throw e;
        }
        return attrs;
    }

    @Override
    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        RepositoryPermissions permissions = this.repository.getPermissions();
        try {
            this.channel.cd("/");
            String basedir = this.getRepository().getBasedir();
            int directoryMode = this.getDirectoryMode(permissions);
            this.mkdirs(basedir + "/", directoryMode);
            this.fireTransferDebug("Recursively uploading directory " + sourceDirectory.getAbsolutePath() + " as " + destinationDirectory);
            this.mkdirs(destinationDirectory, directoryMode);
            this.ftpRecursivePut(sourceDirectory, null, ScpHelper.getResourceFilename((String)destinationDirectory), directoryMode);
        }
        catch (SftpException e) {
            String msg = "Error occurred while deploying '" + sourceDirectory.getAbsolutePath() + "' " + "to remote repository: " + this.getRepository().getUrl() + ": " + e.getMessage();
            throw new TransferFailedException(msg, (Throwable)e);
        }
    }

    private void ftpRecursivePut(File sourceFile, String prefix, String fileName, int directoryMode) throws TransferFailedException, SftpException {
        RepositoryPermissions permissions = this.repository.getPermissions();
        if (sourceFile.isDirectory()) {
            File[] files;
            if (!fileName.equals(".") && !fileName.equals("")) {
                prefix = this.getFileName(prefix, fileName);
                this.mkdir(fileName, directoryMode);
                this.channel.cd(fileName);
            }
            if ((files = sourceFile.listFiles()) != null && files.length > 0) {
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    this.ftpRecursivePut(file, prefix, file.getName(), directoryMode);
                }
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    this.ftpRecursivePut(file, prefix, file.getName(), directoryMode);
                }
            }
            this.channel.cd("..");
        } else {
            Resource resource = ScpHelper.getResource((String)this.getFileName(prefix, fileName));
            this.firePutInitiated(resource, sourceFile);
            this.putFile(sourceFile, resource, permissions);
        }
    }

    private String getFileName(String prefix, String fileName) {
        prefix = prefix != null ? prefix + "/" + fileName : fileName;
        return prefix;
    }

    @Override
    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (destinationDirectory.length() == 0) {
            destinationDirectory = ".";
        }
        String filename = ScpHelper.getResourceFilename((String)destinationDirectory);
        String dir = ScpHelper.getResourceDirectory((String)destinationDirectory);
        if (dir.length() > 0 && dir.charAt(0) == '/') {
            dir = dir.substring(1);
        }
        try {
            SftpATTRS attrs = this.changeToRepositoryDirectory(dir, filename);
            if ((attrs.getPermissions() & 0x4000) == 0) {
                throw new TransferFailedException("Remote path is not a directory:" + dir);
            }
            Vector fileList = this.channel.ls(filename);
            ArrayList<String> files = new ArrayList<String>(fileList.size());
            for (ChannelSftp.LsEntry entry : fileList) {
                String name = entry.getFilename();
                if (entry.getAttrs().isDir()) {
                    if (name.equals(".") || name.equals("..")) continue;
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    files.add(name);
                    continue;
                }
                files.add(name);
            }
            return files;
        }
        catch (SftpException e) {
            String msg = "Error occurred while listing '" + destinationDirectory + "' " + "on remote repository: " + this.getRepository().getUrl() + ": " + e.getMessage();
            throw new TransferFailedException(msg, (Throwable)e);
        }
    }

    @Override
    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        String filename = ScpHelper.getResourceFilename((String)resourceName);
        String dir = ScpHelper.getResourceDirectory((String)resourceName);
        if (dir.length() > 0 && dir.charAt(0) == '/') {
            dir = dir.substring(1);
        }
        try {
            this.changeToRepositoryDirectory(dir, filename);
            return true;
        }
        catch (ResourceDoesNotExistException e) {
            return false;
        }
        catch (SftpException e) {
            String msg = "Error occurred while looking for '" + resourceName + "' " + "on remote repository: " + this.getRepository().getUrl() + ": " + e.getMessage();
            throw new TransferFailedException(msg, (Throwable)e);
        }
    }

    protected void cleanupGetTransfer(Resource resource) {
        this.returnToParentDirectory(resource);
    }

    protected void cleanupPutTransfer(Resource resource) {
        this.returnToParentDirectory(resource);
    }

    protected void finishPutTransfer(Resource resource, InputStream input, OutputStream output) throws TransferFailedException {
        RepositoryPermissions permissions = this.getRepository().getPermissions();
        String filename = ScpHelper.getResourceFilename((String)resource.getName());
        if (permissions != null && permissions.getGroup() != null) {
            this.setGroup(filename, permissions);
        }
        if (permissions != null && permissions.getFileMode() != null) {
            this.setFileMode(filename, permissions);
        }
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        Resource resource = inputData.getResource();
        String filename = ScpHelper.getResourceFilename((String)resource.getName());
        String dir = ScpHelper.getResourceDirectory((String)resource.getName());
        if (dir.length() > 0 && dir.charAt(0) == '/') {
            dir = dir.substring(1);
        }
        try {
            SftpATTRS attrs = this.changeToRepositoryDirectory(dir, filename);
            long lastModified = (long)attrs.getMTime() * 1000L;
            resource.setContentLength(attrs.getSize());
            resource.setLastModified(lastModified);
            inputData.setInputStream(this.channel.get(filename));
        }
        catch (SftpException e) {
            this.handleGetException(resource, (Exception)((Object)e));
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        int directoryMode = this.getDirectoryMode(this.getRepository().getPermissions());
        Resource resource = outputData.getResource();
        try {
            this.channel.cd("/");
            String basedir = this.getRepository().getBasedir();
            this.mkdirs(basedir + "/", directoryMode);
            this.mkdirs(resource.getName(), directoryMode);
            String filename = ScpHelper.getResourceFilename((String)resource.getName());
            outputData.setOutputStream(this.channel.put(filename));
        }
        catch (TransferFailedException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw e;
        }
        catch (SftpException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            String msg = "Error occurred while deploying '" + resource.getName() + "' " + "to remote repository: " + this.getRepository().getUrl() + ": " + e.getMessage();
            throw new TransferFailedException(msg, (Throwable)e);
        }
    }

    public int getDirectoryMode(RepositoryPermissions permissions) {
        int ret = -1;
        if (permissions != null) {
            ret = this.getOctalMode(permissions.getDirectoryMode());
        }
        return ret;
    }

    public int getOctalMode(String mode) {
        int ret;
        try {
            ret = Integer.valueOf(mode, 8);
        }
        catch (NumberFormatException e) {
            this.fireTransferDebug("the file mode must be a numerical mode for SFTP");
            ret = -1;
        }
        return ret;
    }
}

