/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.log.api;

import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;

public final class ConsoleLoggerDecorator
implements ConsoleLogger {
    private final Object logger;

    public ConsoleLoggerDecorator(Object logger) {
        if (logger == null) {
            throw new NullPointerException("logger argument is null in " + ConsoleLoggerDecorator.class);
        }
        this.logger = logger;
    }

    @Override
    public void debug(String message) {
        try {
            this.logger.getClass().getMethod("debug", String.class).invoke(this.logger, message);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void info(String message) {
        try {
            this.logger.getClass().getMethod("info", String.class).invoke(this.logger, message);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void warning(String message) {
        try {
            this.logger.getClass().getMethod("warning", String.class).invoke(this.logger, message);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void error(String message) {
        try {
            this.logger.getClass().getMethod("error", String.class).invoke(this.logger, message);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        try {
            this.logger.getClass().getMethod("error", String.class, Throwable.class).invoke(this.logger, message, t);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void error(Throwable t) {
        try {
            this.logger.getClass().getMethod("error", Throwable.class).invoke(this.logger, t);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }
}

