/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.maven.surefire.common.junit3.JUnit3Reflector;
import org.apache.maven.surefire.junit.SurefireTestSet;
import org.apache.maven.surefire.junit.TestListenerInvocationHandler;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.testset.TestSetFailedException;

public final class JUnitTestSet
implements SurefireTestSet {
    private Method runMethod;
    private final Class testClass;
    private final JUnit3Reflector reflector;

    public JUnitTestSet(Class testClass, JUnit3Reflector reflector) throws TestSetFailedException {
        if (testClass == null) {
            throw new NullPointerException("testClass is null");
        }
        this.testClass = testClass;
        this.reflector = reflector;
        this.runMethod = this.reflector.getTestInterface().isAssignableFrom(this.testClass) ? this.reflector.getTestInterfaceRunMethod() : reflector.getRunMethod(this.testClass);
    }

    public void execute(Reporter reportManager, ClassLoader loader) throws TestSetFailedException {
        Class testClass = this.getTestClass();
        try {
            Object testObject = this.reflector.constructTestObject(testClass);
            Object instanceOfTestResult = this.reflector.getTestResultClass().newInstance();
            TestListenerInvocationHandler invocationHandler = new TestListenerInvocationHandler(reportManager, instanceOfTestResult, loader);
            Object testListener = Proxy.newProxyInstance(loader, this.reflector.getInterfacesImplementedByDynamicProxy(), (InvocationHandler)invocationHandler);
            Object[] addTestListenerParams = new Object[]{testListener};
            this.reflector.getAddListenerMethod().invoke(instanceOfTestResult, addTestListenerParams);
            Object[] runParams = new Object[]{instanceOfTestResult};
            this.runMethod.invoke(testObject, runParams);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(testClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(testClass.getName(), e.getTargetException());
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException("JUnit classes not available", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Class is not a JUnit TestCase", (Throwable)e);
        }
    }

    public String getName() {
        return this.testClass.getName();
    }

    public Class getTestClass() {
        return this.testClass;
    }
}

