/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.junit.Ignore;
import org.junit.runner.Description;

public final class JUnit4Reflector {
    private static final Class<?>[] PARAMS = new Class[]{Class.class};
    private static final Object[] IGNORE_PARAMS = new Object[]{Ignore.class};
    private static final Class<?>[] PARAMS_WITH_ANNOTATIONS = new Class[]{String.class, Annotation[].class};

    private JUnit4Reflector() {
        throw new IllegalStateException("not instantiable constructor");
    }

    public static Ignore getAnnotatedIgnore(Description d) {
        Method getAnnotation = ReflectionUtils.tryGetMethod(d.getClass(), (String)"getAnnotation", (Class[])PARAMS);
        return getAnnotation == null ? null : (Ignore)ReflectionUtils.invokeMethodWithArray((Object)d, (Method)getAnnotation, (Object[])IGNORE_PARAMS);
    }

    static String getAnnotatedIgnoreValue(Description description) {
        Ignore ignore = JUnit4Reflector.getAnnotatedIgnore(description);
        return ignore != null ? ignore.value() : null;
    }

    public static Description createDescription(String description) {
        try {
            return Description.createSuiteDescription((String)description);
        }
        catch (NoSuchMethodError e) {
            Method method = ReflectionUtils.getMethod(Description.class, (String)"createSuiteDescription", (Class[])PARAMS_WITH_ANNOTATIONS);
            return (Description)ReflectionUtils.invokeMethodWithArray(null, (Method)method, (Object[])new Object[]{description, new Annotation[0]});
        }
    }

    public static Description createDescription(String description, Annotation ... annotations) {
        Method method = ReflectionUtils.tryGetMethod(Description.class, (String)"createSuiteDescription", (Class[])PARAMS_WITH_ANNOTATIONS);
        return method == null ? Description.createSuiteDescription((String)description) : (Description)ReflectionUtils.invokeMethodWithArray(null, (Method)method, (Object[])new Object[]{description, annotations});
    }

    public static Ignore createIgnored(String value) {
        return new IgnoredWithUserError(value);
    }

    private static class IgnoredWithUserError
    implements Annotation,
    Ignore {
        private final String value;

        IgnoredWithUserError(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Ignore.class;
        }

        @Override
        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Ignore && this.equalValue((Ignore)obj);
        }

        @Override
        public String toString() {
            return String.format("%s(%s)", Ignore.class, this.value);
        }

        private boolean equalValue(Ignore ignore) {
            return ignore != null && ignore.value().equals(this.value);
        }
    }
}

