/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public final class MatchDescriptions
extends Filter {
    private final List<Filter> filters = new ArrayList<Filter>();

    public MatchDescriptions(Iterable<Description> descriptions) {
        for (Description description : descriptions) {
            this.filters.add(MatchDescriptions.matchDescription(description));
        }
    }

    public boolean shouldRun(Description description) {
        for (Filter filter : this.filters) {
            if (!filter.shouldRun(description)) continue;
            return true;
        }
        return false;
    }

    public String describe() {
        StringBuilder description = new StringBuilder("Matching description ");
        for (int i = 0; i < this.filters.size(); ++i) {
            description.append(this.filters.get(i).describe());
            if (i == this.filters.size() - 1) continue;
            description.append(" OR ");
        }
        return description.toString();
    }

    private static Filter matchDescription(final Description desiredDescription) {
        return new Filter(){

            public boolean shouldRun(Description description) {
                if (description.isTest()) {
                    return desiredDescription.equals((Object)description);
                }
                for (Description each : description.getChildren()) {
                    if (!this.shouldRun(each)) continue;
                    return true;
                }
                return false;
            }

            public String describe() {
                return String.format("Method %s", desiredDescription.getDisplayName());
            }
        };
    }
}

