/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.hash;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarEntry;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.JarData;
import org.apache.maven.shared.jar.identification.hash.JarHashAnalyzer;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.digest.StreamingDigester;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class JarBytecodeHashAnalyzer
extends AbstractLogEnabled
implements JarHashAnalyzer {
    private StreamingDigester digester;

    public String computeHash(JarAnalyzer jarAnalyzer) {
        JarData jarData = jarAnalyzer.getJarData();
        String result = jarData.getBytecodeHash();
        if (result == null) {
            Iterator it = jarAnalyzer.getClassEntries().iterator();
            try {
                this.digester.reset();
                while (it.hasNext()) {
                    JarEntry entry = (JarEntry)it.next();
                    this.computeEntryBytecodeHash(jarAnalyzer.getEntryInputStream(entry));
                }
                result = this.digester.calc();
                jarData.setBytecodeHash(result);
            }
            catch (DigesterException e) {
                this.getLogger().warn("Unable to calculate the hashcode.", (Throwable)e);
            }
            catch (IOException e) {
                this.getLogger().warn("Unable to calculate the hashcode.", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEntryBytecodeHash(InputStream is) throws IOException, DigesterException {
        try {
            this.digester.update(is);
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    public void setDigester(StreamingDigester digester) {
        this.digester = digester;
    }
}

