/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDependencyAnalysis {
    private final Set<Artifact> usedDeclaredArtifacts;
    private final Set<Artifact> usedUndeclaredArtifacts;
    private final Set<Artifact> unusedDeclaredArtifacts;

    public ProjectDependencyAnalysis() {
        this(null, null, null);
    }

    public ProjectDependencyAnalysis(Set<Artifact> usedDeclaredArtifacts, Set<Artifact> usedUndeclaredArtifacts, Set<Artifact> unusedDeclaredArtifacts) {
        this.usedDeclaredArtifacts = this.safeCopy(usedDeclaredArtifacts);
        this.usedUndeclaredArtifacts = this.safeCopy(usedUndeclaredArtifacts);
        this.unusedDeclaredArtifacts = this.safeCopy(unusedDeclaredArtifacts);
    }

    public Set<Artifact> getUsedDeclaredArtifacts() {
        return this.usedDeclaredArtifacts;
    }

    public Set<Artifact> getUsedUndeclaredArtifacts() {
        return this.usedUndeclaredArtifacts;
    }

    public Set<Artifact> getUnusedDeclaredArtifacts() {
        return this.unusedDeclaredArtifacts;
    }

    public ProjectDependencyAnalysis ignoreNonCompile() {
        HashSet<Artifact> filteredUnusedDeclared = new HashSet<Artifact>(this.unusedDeclaredArtifacts);
        Iterator iter = filteredUnusedDeclared.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (artifact.getScope().equals("compile")) continue;
            iter.remove();
        }
        return new ProjectDependencyAnalysis(this.usedDeclaredArtifacts, this.usedUndeclaredArtifacts, filteredUnusedDeclared);
    }

    public ProjectDependencyAnalysis forceDeclaredDependenciesUsage(String[] forceUsedDependencies) throws ProjectDependencyAnalyzerException {
        HashSet<String> forced = new HashSet<String>(Arrays.asList(forceUsedDependencies));
        HashSet<Artifact> forcedUnusedDeclared = new HashSet<Artifact>(this.unusedDeclaredArtifacts);
        HashSet<Artifact> forcedUsedDeclared = new HashSet<Artifact>(this.usedDeclaredArtifacts);
        Iterator iter = forcedUnusedDeclared.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!forced.remove(artifact.getGroupId() + ':' + artifact.getArtifactId())) continue;
            iter.remove();
            forcedUsedDeclared.add(artifact);
        }
        if (!forced.isEmpty()) {
            HashSet<String> used = new HashSet<String>();
            for (Artifact artifact : this.usedDeclaredArtifacts) {
                String id = artifact.getGroupId() + ':' + artifact.getArtifactId();
                if (!forced.remove(id)) continue;
                used.add(id);
            }
            StringBuilder builder = new StringBuilder();
            if (!forced.isEmpty()) {
                builder.append("not declared: " + forced);
            }
            if (!used.isEmpty()) {
                if (builder.length() > 0) {
                    builder.append(" and ");
                }
                builder.append("declared but already detected as used: " + used);
            }
            throw new ProjectDependencyAnalyzerException("Trying to force use of dependencies which are " + builder);
        }
        return new ProjectDependencyAnalysis(forcedUsedDeclared, this.usedUndeclaredArtifacts, forcedUnusedDeclared);
    }

    public int hashCode() {
        int hashCode = ((Object)this.getUsedDeclaredArtifacts()).hashCode();
        hashCode = hashCode * 37 + ((Object)this.getUsedUndeclaredArtifacts()).hashCode();
        hashCode = hashCode * 37 + ((Object)this.getUnusedDeclaredArtifacts()).hashCode();
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectDependencyAnalysis) {
            ProjectDependencyAnalysis analysis = (ProjectDependencyAnalysis)object;
            return ((Object)this.getUsedDeclaredArtifacts()).equals(analysis.getUsedDeclaredArtifacts()) && ((Object)this.getUsedUndeclaredArtifacts()).equals(analysis.getUsedUndeclaredArtifacts()) && ((Object)this.getUnusedDeclaredArtifacts()).equals(analysis.getUnusedDeclaredArtifacts());
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (!this.getUsedDeclaredArtifacts().isEmpty()) {
            buffer.append("usedDeclaredArtifacts=").append(this.getUsedDeclaredArtifacts());
        }
        if (!this.getUsedUndeclaredArtifacts().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append("usedUndeclaredArtifacts=").append(this.getUsedUndeclaredArtifacts());
        }
        if (!this.getUnusedDeclaredArtifacts().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append("unusedDeclaredArtifacts=").append(this.getUnusedDeclaredArtifacts());
        }
        buffer.insert(0, "[");
        buffer.insert(0, this.getClass().getName());
        buffer.append("]");
        return buffer.toString();
    }

    private Set<Artifact> safeCopy(Set<Artifact> set) {
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<Artifact>(set));
    }
}

