/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.fileset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.shared.model.fileset.Mapper;

public class SetBase
implements Serializable {
    private boolean followSymlinks = false;
    private String outputDirectory;
    private boolean useDefaultExcludes = false;
    private List includes;
    private List excludes;
    private String fileMode = "0644";
    private String directoryMode = "0755";
    private Mapper mapper = new Mapper();
    private String modelEncoding = "UTF-8";

    public void addExclude(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("SetBase.addExcludes(string) parameter must be instanceof " + String.class.getName());
        }
        this.getExcludes().add(string);
    }

    public void addInclude(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("SetBase.addIncludes(string) parameter must be instanceof " + String.class.getName());
        }
        this.getIncludes().add(string);
    }

    public String getDirectoryMode() {
        return this.directoryMode;
    }

    public List getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList();
        }
        return this.excludes;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public List getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList();
        }
        return this.includes;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void removeExclude(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("SetBase.removeExcludes(string) parameter must be instanceof " + String.class.getName());
        }
        this.getExcludes().remove(string);
    }

    public void removeInclude(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("SetBase.removeIncludes(string) parameter must be instanceof " + String.class.getName());
        }
        this.getIncludes().remove(string);
    }

    public void setDirectoryMode(String directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setExcludes(List excludes) {
        this.excludes = excludes;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public String[] getIncludesArray() {
        String[] includesArry = null;
        List includes = this.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            includesArry = includes.toArray(new String[0]);
        } else if (includes != null) {
            includesArry = new String[]{};
        }
        return includesArry;
    }

    public String[] getExcludesArray() {
        String[] excludesArry = null;
        List excludes = this.getExcludes();
        if (excludes != null && !excludes.isEmpty()) {
            excludesArry = excludes.toArray(new String[0]);
        } else if (excludes != null) {
            excludesArry = new String[]{};
        }
        return excludesArry;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

