/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MMap<K, V> {
    private static final MMap<?, ?> EMPTY_MAP = new MMap(new HashMap(0)).done();
    protected final HashMap<K, V> delegate;

    public static <K, V> MMap<K, V> empty() {
        return EMPTY_MAP;
    }

    public static <K, V> MMap<K, V> copy(MMap<K, V> orig) {
        return new MMap<K, V>(new HashMap<K, V>(orig.delegate));
    }

    public static <K, V> MMap<K, Collection<V>> copyWithKey(K key, MMap<K, Collection<V>> orig) {
        HashMap<Object, Collection> delegateLocal = new HashMap<Object, Collection>(orig.delegate);
        delegateLocal.computeIfPresent(key, (k, v) -> new ArrayList(v));
        return new MMap<K, V>(delegateLocal);
    }

    private MMap(HashMap<K, V> delegate) {
        this.delegate = delegate;
    }

    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    public V get(K key) {
        return this.delegate.get(key);
    }

    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    public MMap<K, V> done() {
        return new DoneMMap(this.delegate);
    }

    public int hashCode() {
        throw new IllegalStateException("MMap is not done yet");
    }

    public boolean equals(Object o) {
        throw new IllegalStateException("MMap is not done yet");
    }

    private static class DoneMMap<K, V>
    extends MMap<K, V> {
        private final int hashCode;

        private DoneMMap(HashMap<K, V> delegate) {
            super(delegate);
            this.hashCode = delegate.hashCode();
        }

        @Override
        public V put(K key, V value) {
            throw new IllegalStateException("Done MMap is immutable");
        }

        @Override
        public MMap<K, V> done() {
            return this;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MMap)) {
                return false;
            }
            MMap other = (MMap)o;
            return this.delegate.equals(other.delegate);
        }
    }
}

