/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jar;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.Mojo;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.archiver.MavenArchiverException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public abstract class AbstractJarMojo
implements Mojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String MODULE_DESCRIPTOR_FILE_NAME = "module-info.class";
    private static final String SEPARATOR = FileSystems.getDefault().getSeparator();
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private Path outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Inject
    private Map<String, Archiver> archivers;
    @Inject
    private Project project;
    @Inject
    private Session session;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="jar.useDefaultManifestFile", defaultValue="false")
    @Deprecated
    private boolean useDefaultManifestFile;
    @Inject
    private ProjectManager projectManager;
    @Parameter(property="maven.jar.forceCreation", defaultValue="false")
    private boolean forceCreation;
    @Parameter(defaultValue="false")
    private boolean skipIfEmpty;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(property="maven.jar.detectMultiReleaseJar", defaultValue="true")
    private boolean detectMultiReleaseJar;
    @Inject
    private Log log;

    protected abstract Path getClassesDirectory();

    protected final Project getProject() {
        return this.project;
    }

    protected final Log getLog() {
        return this.log;
    }

    protected abstract String getClassifier();

    protected abstract String getType();

    protected Path getJarFile(Path basedir, String resultFinalName, String classifier) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (resultFinalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        String fileName = resultFinalName + (String)(this.hasClassifier() ? "-" + classifier : "") + ".jar";
        return basedir.resolve(fileName);
    }

    public Path createArchive() throws MojoException {
        boolean containsModuleDescriptor;
        Path jarFile = this.getJarFile(this.outputDirectory, this.finalName, this.getClassifier());
        FileSetManager fileSetManager = new FileSetManager();
        FileSet jarContentFileSet = new FileSet();
        jarContentFileSet.setDirectory(this.getClassesDirectory().toAbsolutePath().toString());
        jarContentFileSet.setIncludes(Arrays.asList(this.getIncludes()));
        jarContentFileSet.setExcludes(Arrays.asList(this.getExcludes()));
        String[] includedFiles = fileSetManager.getIncludedFiles(jarContentFileSet);
        if (this.detectMultiReleaseJar && Arrays.stream(includedFiles).anyMatch(p -> p.startsWith("META-INF" + SEPARATOR + "versions" + SEPARATOR))) {
            this.getLog().debug((CharSequence)"Adding 'Multi-Release: true' manifest entry.");
            this.archive.addManifestEntry("Multi-Release", "true");
        }
        String archiverName = (containsModuleDescriptor = Arrays.stream(includedFiles).anyMatch(p -> p.endsWith(MODULE_DESCRIPTOR_FILE_NAME))) ? "mjar" : "jar";
        MavenArchiver archiver = new MavenArchiver();
        archiver.setCreatedBy("Maven JAR Plugin", "org.apache.maven.plugins", "maven-jar-plugin");
        archiver.setArchiver((JarArchiver)this.archivers.get(archiverName));
        archiver.setOutputFile(jarFile.toFile());
        archiver.configureReproducibleBuild(this.outputTimestamp);
        this.archive.setForced(this.forceCreation);
        try {
            Path contentDirectory = this.getClassesDirectory();
            if (!Files.exists(contentDirectory, new LinkOption[0])) {
                if (!this.forceCreation) {
                    this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
                }
            } else {
                archiver.getArchiver().addDirectory(contentDirectory.toFile(), this.getIncludes(), this.getExcludes());
            }
            archiver.createArchive(this.session, this.project, this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoException("Error assembling JAR", (Throwable)e);
        }
    }

    public void execute() throws MojoException {
        if (this.useDefaultManifestFile) {
            throw new MojoException("You are using 'useDefaultManifestFile' which has been removed from the maven-jar-plugin. Please see the >>Major Version Upgrade to version 3.0.0<< on the plugin site.");
        }
        if (this.skipIfEmpty && this.isEmpty(this.getClassesDirectory())) {
            this.getLog().info((CharSequence)("Skipping packaging of the " + this.getType()));
        } else {
            Artifact artifact;
            Path jarFile = this.createArchive();
            if (this.hasClassifier()) {
                artifact = this.session.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.getClassifier(), null, this.getType());
            } else {
                if (this.projectHasAlreadySetAnArtifact()) {
                    throw new MojoException("You have to use a classifier to attach supplemental artifacts to the project instead of replacing them.");
                }
                artifact = (Artifact)this.project.getMainArtifact().get();
            }
            this.projectManager.attachArtifact(this.project, artifact, jarFile);
        }
    }

    private boolean isEmpty(Path directory) {
        boolean bl;
        block9: {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                return true;
            }
            Stream<Path> children = Files.list(directory);
            try {
                boolean bl2 = bl = !children.findAny().isPresent();
                if (children == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (children != null) {
                        try {
                            children.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MavenArchiverException("Unable to access directory", (Throwable)e);
                }
            }
            children.close();
        }
        return bl;
    }

    private boolean projectHasAlreadySetAnArtifact() {
        Path path = this.projectManager.getPath(this.project).orElse(null);
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }

    protected boolean hasClassifier() {
        return this.getClassifier() != null && !this.getClassifier().trim().isEmpty();
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }
}

