/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.apache.maven.shared.utils.ReaderFactory;
import org.apache.maven.shared.utils.WriterFactory;
import org.apache.maven.shared.utils.io.IOUtil;
import org.apache.maven.shared.utils.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="install-file", requiresProject=false, aggregator=true, threadSafe=true)
public class InstallFileMojo
extends AbstractInstallMojo {
    @Parameter(property="groupId")
    protected String groupId;
    @Parameter(property="artifactId")
    protected String artifactId;
    @Parameter(property="version")
    protected String version;
    @Parameter(property="packaging")
    protected String packaging;
    @Parameter(property="classifier")
    protected String classifier;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom")
    private Boolean generatePom;
    @Parameter(property="repositoryLayout", defaultValue="default", required=true)
    private String repositoryLayout;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter(property="localRepositoryPath")
    private File localRepositoryPath;
    @Component
    private ModelValidator modelValidator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.file.exists()) {
            String message = "The specified file '" + this.file.getPath() + "' not exists";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        if (this.localRepositoryPath != null) {
            try {
                ArtifactRepositoryLayout layout = this.repositoryLayouts.get(this.repositoryLayout);
                this.getLog().debug((CharSequence)("Layout: " + layout.getClass()));
                this.localRepository = new DefaultArtifactRepository(this.localRepository.getId(), this.localRepositoryPath.toURL().toString(), layout);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("MalformedURLException: " + e.getMessage(), (Exception)e);
            }
        }
        if (this.pomFile != null) {
            this.processModel(this.readModel(this.pomFile));
        } else {
            boolean foundPom = false;
            try {
                Pattern pomEntry = Pattern.compile("META-INF/maven/.*/pom\\.xml");
                JarFile jarFile = new JarFile(this.file);
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry = jarEntries.nextElement();
                    if (!pomEntry.matcher(entry.getName()).matches()) continue;
                    this.getLog().debug((CharSequence)("Using " + entry.getName() + " for groupId, artifactId, packaging and version"));
                    foundPom = true;
                    InputStream pomInputStream = null;
                    try {
                        pomInputStream = jarFile.getInputStream(entry);
                        this.processModel(this.readModel(pomInputStream));
                        break;
                    }
                    finally {
                        if (pomInputStream != null) {
                            pomInputStream.close();
                        }
                    }
                }
                if (!foundPom) {
                    this.getLog().info((CharSequence)("pom.xml not found in " + this.file.getName()));
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.validateArtifactInformation();
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        if (this.file.equals(this.getLocalRepoFile(artifact))) {
            throw new MojoFailureException("Cannot install artifact. Artifact is already in the local repository.\n\nFile in question is: " + this.file + "\n");
        }
        File generatedPomFile = null;
        if (!"pom".equals(this.packaging)) {
            ProjectArtifactMetadata pomMetadata;
            if (this.pomFile != null) {
                pomMetadata = new ProjectArtifactMetadata(artifact, this.pomFile);
                artifact.addMetadata((ArtifactMetadata)pomMetadata);
            } else {
                generatedPomFile = this.generatePomFile();
                pomMetadata = new ProjectArtifactMetadata(artifact, generatedPomFile);
                if (Boolean.TRUE.equals(this.generatePom) || this.generatePom == null && !this.getLocalRepoFile((ArtifactMetadata)pomMetadata).exists()) {
                    this.getLog().debug((CharSequence)"Installing generated POM");
                    artifact.addMetadata((ArtifactMetadata)pomMetadata);
                } else if (this.generatePom == null) {
                    this.getLog().debug((CharSequence)"Skipping installation of generated POM, already present in local repository");
                }
            }
        }
        if (this.updateReleaseInfo) {
            artifact.setRelease(true);
        }
        LinkedHashSet<File> metadataFiles = new LinkedHashSet<File>();
        try {
            this.installer.install(this.file, artifact, this.localRepository);
            this.installChecksums(artifact);
            this.addMetaDataFilesForArtifact(artifact, metadataFiles);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Error installing artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (generatedPomFile != null) {
                generatedPomFile.delete();
            }
        }
        if (this.sources != null) {
            artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, "jar", "sources");
            try {
                this.installer.install(this.sources, artifact, this.localRepository);
                this.installChecksums(artifact);
                this.addMetaDataFilesForArtifact(artifact, metadataFiles);
            }
            catch (ArtifactInstallationException e) {
                throw new MojoExecutionException("Error installing sources " + this.sources + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
        if (this.javadoc != null) {
            artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, "jar", "javadoc");
            try {
                this.installer.install(this.javadoc, artifact, this.localRepository);
                this.installChecksums(artifact);
                this.addMetaDataFilesForArtifact(artifact, metadataFiles);
            }
            catch (ArtifactInstallationException e) {
                throw new MojoExecutionException("Error installing API docs " + this.javadoc + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
        this.installChecksums(metadataFiles);
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        Reader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            Model model = new MavenXpp3Reader().read(reader);
            return model;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File not found " + pomFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private Model readModel(InputStream pomFile) throws MojoExecutionException {
        Reader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((InputStream)pomFile);
            Model model = new MavenXpp3Reader().read(reader);
            return model;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File not found " + pomFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private void validateArtifactInformation() throws MojoExecutionException {
        Model model = this.generateModel();
        ModelValidationResult result = this.modelValidator.validate(model);
        if (result.getMessageCount() > 0) {
            throw new MojoExecutionException("The artifact information is incomplete or not valid:\n" + result.render("  "));
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription("POM was created from install:install-file");
        return model;
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter writer = null;
        try {
            File pomFile = File.createTempFile("mvninstall", ".pom");
            writer = WriterFactory.newXmlWriter((File)pomFile);
            new MavenXpp3Writer().write((Writer)writer, model);
            file = pomFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary POM file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return file;
    }

    public File getLocalRepositoryPath() {
        return this.localRepositoryPath;
    }

    public void setLocalRepositoryPath(File theLocalRepositoryPath) {
        this.localRepositoryPath = theLocalRepositoryPath;
    }
}

