/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.idea;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.idea.AbstractIdeaMojo;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class IdeaWorkspaceMojo
extends AbstractIdeaMojo {
    public void execute() throws MojoExecutionException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.rewriteWorkspace();
    }

    public void rewriteWorkspace() throws MojoExecutionException {
        File workspaceFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iws");
        try {
            Document document = this.readXmlDocument(workspaceFile, "workspace.xml");
            Element module = document.getRootElement();
            this.setProjectScmType(module);
            this.writeXmlDocument(workspaceFile, document);
        }
        catch (DocumentException e) {
            throw new MojoExecutionException("Error parsing existing IWS file: " + workspaceFile.getAbsolutePath(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create workspace file", (Exception)e);
        }
    }

    private void setProjectScmType(Element content) {
        String scmType = this.getScmType();
        if (scmType != null) {
            Element component = this.findComponent(content, "VcsManagerConfiguration");
            Element element = this.findElement(component, "option", "ACTIVE_VCS_NAME");
            element.addAttribute("value", scmType);
        }
    }

    protected String getScmType() {
        if (this.executedProject.getScm() == null) {
            return null;
        }
        String scmType = this.getScmType(this.executedProject.getScm().getConnection());
        if (scmType != null) {
            return scmType;
        }
        scmType = this.getScmType(this.executedProject.getScm().getDeveloperConnection());
        return scmType;
    }

    protected String getScmType(String connection) {
        if (connection != null && connection.length() > 0) {
            int startIndex = connection.indexOf(":");
            int endIndex = connection.indexOf("|", startIndex + 1);
            if (endIndex == -1) {
                endIndex = connection.indexOf(":", startIndex + 1);
            }
            if (startIndex < endIndex) {
                String scmType = connection.substring(startIndex + 1, endIndex);
                scmType = this.translateScmType(scmType);
                return scmType;
            }
        }
        return null;
    }

    protected String translateScmType(String scmType) {
        if ("cvs".equals(scmType)) {
            return "CVS";
        }
        if ("perforce".equals(scmType)) {
            return "Perforce";
        }
        if ("starteam".equals(scmType)) {
            return "StarTeam";
        }
        if ("vss".equals(scmType)) {
            return "SourceSafe";
        }
        return scmType;
    }
}

