/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.rad;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseManifestWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.project.MavenProject;

public class RadManifestWriter
extends AbstractEclipseManifestWriter {
    private static final String DEFAULT_WEBAPP_RESOURCE_DIR = "src" + File.separatorChar + "main" + File.separatorChar + "webapp";

    protected String getMetaInfBaseDirectory(MavenProject project) throws MojoExecutionException {
        String metaInfBaseDirectory = null;
        if (this.config.getProject().getPackaging().equals("war")) {
            File warSourceDirectory = new File(IdeUtils.getPluginSetting(this.config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", DEFAULT_WEBAPP_RESOURCE_DIR));
            String webContentDir = IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), warSourceDirectory, false);
            metaInfBaseDirectory = this.config.getProject().getBasedir().getAbsolutePath() + File.separatorChar + webContentDir;
            this.log.debug((CharSequence)("Attempting to use: " + metaInfBaseDirectory + " for location of META-INF in war project."));
            File metaInfDirectoryFile = new File(metaInfBaseDirectory + File.separatorChar + "META-INF");
            if (metaInfDirectoryFile.exists() && !metaInfDirectoryFile.isDirectory()) {
                metaInfBaseDirectory = null;
            }
        }
        if (metaInfBaseDirectory == null) {
            Iterator iterator = project.getResources().iterator();
            while (iterator.hasNext()) {
                metaInfBaseDirectory = ((Resource)iterator.next()).getDirectory();
                File metaInfDirectoryFile = new File(metaInfBaseDirectory + File.separatorChar + "META-INF");
                this.log.debug((CharSequence)("Checking for existence of META-INF directory: " + metaInfDirectoryFile));
                if (!metaInfDirectoryFile.exists() || metaInfDirectoryFile.isDirectory()) continue;
                metaInfBaseDirectory = null;
            }
        }
        return metaInfBaseDirectory;
    }

    public void write() throws MojoExecutionException {
        super.write();
        this.verifyManifestBasedirInSourceDirs(this.getMetaInfBaseDirectory(this.config.getProject()));
    }

    private void verifyManifestBasedirInSourceDirs(String metaInfBaseDirectory) {
        EclipseSourceDir[] sourceDirs = this.config.getSourceDirs();
        if (sourceDirs != null) {
            boolean foundMetaInfBaseDirectory = false;
            for (int i = 0; i < sourceDirs.length; ++i) {
                EclipseSourceDir esd = sourceDirs[i];
                if (!esd.getPath().equals(metaInfBaseDirectory)) continue;
                foundMetaInfBaseDirectory = true;
                break;
            }
            if (!foundMetaInfBaseDirectory) {
                EclipseSourceDir dir = new EclipseSourceDir(metaInfBaseDirectory, null, true, false, null, null, false);
                EclipseSourceDir[] newSourceDirs = new EclipseSourceDir[sourceDirs.length + 1];
                newSourceDirs[sourceDirs.length] = dir;
                System.arraycopy(sourceDirs, 0, newSourceDirs, 0, sourceDirs.length);
                this.config.setSourceDirs(newSourceDirs);
            }
        }
    }
}

